/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.insurance.claim;

import java.util.List;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.workspace.patient.insurance.claim.AbstractInsuranceLayoutStrategy;

public abstract class AbstractClaimLayoutStrategy
extends AbstractInsuranceLayoutStrategy {
    protected static final String MESSAGE = "message";
    protected static final String GAP_CLAIM = "gapClaim";

    public AbstractClaimLayoutStrategy(boolean showGapClaim) {
        ArchetypeNodes nodes = ArchetypeNodes.all().exclude(new String[]{"policy"}).excludeIfEmpty(new String[]{MESSAGE, "insurerId", "deposits"});
        this.setArchetypeNodes(nodes);
        if (!showGapClaim) {
            nodes.exclude(new String[]{GAP_CLAIM, "vetBenefitAmount"});
        }
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property message = properties.get(MESSAGE);
        if (!StringUtils.isEmpty((CharSequence)message.getString())) {
            this.addComponent(this.createTextArea(message, object, context));
        }
        this.addComponent(this.createNotes(object, properties, context));
        return super.apply(object, properties, parent, context);
    }

    protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
        ArchetypeNodes.insertAfter(properties, (String)"endTime", (Property[])new Property[]{this.getInsurer(), this.getPolicyNumber()});
        super.doSimpleLayout(object, parent, properties, container, context);
    }

    protected abstract Property getInsurer();

    protected abstract Property getPolicyNumber();
}

