/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.info;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.DefaultIMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.Workflow;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.info.PatientContextHelper;
import org.openvpms.web.workspace.patient.info.PatientMergeWorkflow;
import org.openvpms.web.workspace.workflow.WorkflowFactory;

public class InformationCRUDWindow
extends AbstractViewCRUDWindow<Party> {
    private static final String CHECKIN_ID = "checkin";
    private static final String MERGE_ID = "merge";

    public InformationCRUDWindow(Archetypes<Party> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)DefaultIMObjectActions.getInstance(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(CHECKIN_ID, this::onCheckIn);
        if (UserHelper.isAdmin((User)this.getContext().getUser())) {
            buttons.add(MERGE_ID, this::onMerge);
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(CHECKIN_ID, enable);
        buttons.setEnabled(MERGE_ID, enable);
    }

    protected void onSaved(Party object, boolean isNew) {
        super.onSaved((IMObject)object, isNew);
        this.notifyUpdated(object);
    }

    private void onCheckIn() {
        Context context = this.getContext();
        Party customer = context.getCustomer();
        Party patient = context.getPatient();
        if (customer != null && patient != null) {
            WorkflowFactory factory = (WorkflowFactory)ServiceHelper.getBean(WorkflowFactory.class);
            Workflow workflow = factory.createCheckInWorkflow(customer, patient, context, this.getHelpContext());
            workflow.start();
        } else {
            String title = Messages.get((String)"patient.checkin.title");
            String msg = Messages.get((String)"patient.checkin.needcustomerpatient");
            ErrorHelper.show((String)title, (String)msg);
        }
    }

    private void onMerge() {
        Party customer = this.getContext().getCustomer();
        HelpContext help = this.getHelpContext().subtopic(MERGE_ID);
        PatientMergeWorkflow workflow = new PatientMergeWorkflow((Party)this.getObject(), customer, help);
        workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                if (event.getType() == TaskEvent.Type.COMPLETED) {
                    InformationCRUDWindow.this.onRefresh(InformationCRUDWindow.this.getObject());
                    Party object = (Party)InformationCRUDWindow.this.getObject();
                    if (object != null) {
                        InformationCRUDWindow.this.notifyUpdated(object);
                    }
                }
            }
        });
        workflow.start();
    }

    private void notifyUpdated(Party object) {
        PatientContext context = PatientContextHelper.getPatientContext(object, this.getContext());
        if (context != null) {
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            service.updated(context);
        }
    }
}

