/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSearch
implements Predicate<Act> {
    private final String search;
    private final boolean searchClinician;
    private final boolean searchBatch;
    private final IArchetypeService service;
    private static final Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private static final Logger log = LoggerFactory.getLogger(TextSearch.class);
    private static final Matcher DEFAULT_MATCHER = new Matcher();
    private static final DocumentMatcher DOCUMENT_MATCHER = new DocumentMatcher();
    private static final InvestigationMatcher INVESTIGATION_MATCHER = new InvestigationMatcher();
    private static final NoteMatcher NOTE_MATCHER = new NoteMatcher();
    private static final CommunicationMatcher COMMUNICATION_MATCHER = new CommunicationMatcher();
    private static final LetterMatcher LETTER_MATCHER = new LetterMatcher();

    public TextSearch(String search, boolean searchClinician, boolean searchBatch, IArchetypeService service) {
        this.search = search.toLowerCase();
        this.searchClinician = searchClinician;
        this.searchBatch = searchBatch;
        this.service = service;
    }

    @Override
    public boolean test(Act act) {
        Matcher matcher = matchers.get(act.getArchetype());
        if (matcher == null) {
            matcher = DEFAULT_MATCHER;
        }
        IMObjectBean bean = this.service.getBean((IMObject)act);
        return matcher.match(this.search, bean, this.searchClinician, this.searchBatch);
    }

    static {
        matchers.put("act.patientClinicalAddendum", NOTE_MATCHER);
        matchers.put("act.patientClinicalEvent", new EventMatcher());
        matchers.put("act.patientClinicalNote", NOTE_MATCHER);
        matchers.put("act.patientClinicalProblem", new ProblemMatcher());
        matchers.put("act.customerAccountInvoiceItem", new InvoiceItemMatcher());
        matchers.put("act.patientDocumentAttachment", DOCUMENT_MATCHER);
        matchers.put("act.patientDocumentAttachmentVersion", DOCUMENT_MATCHER);
        matchers.put("act.patientDocumentForm", new FormMatcher());
        matchers.put("act.patientDocumentImage", DOCUMENT_MATCHER);
        matchers.put("act.patientDocumentImageVersion", DOCUMENT_MATCHER);
        matchers.put("act.patientDocumentLetter", LETTER_MATCHER);
        matchers.put("act.patientDocumentLetterVersion", LETTER_MATCHER);
        matchers.put("act.patientInvestigation", INVESTIGATION_MATCHER);
        matchers.put("act.patientInvestigationVersion", INVESTIGATION_MATCHER);
        matchers.put("act.patientMedication", new MedicationMatcher());
        matchers.put("act.patientWeight", DEFAULT_MATCHER);
        matchers.put("act.customerCommunicationEmail", new EmailMatcher());
        matchers.put("act.customerCommunicationNote", COMMUNICATION_MATCHER);
        matchers.put("act.customerCommunicationMail", COMMUNICATION_MATCHER);
        matchers.put("act.customerCommunicationPhone", COMMUNICATION_MATCHER);
        matchers.put("act.smsMessage", new SMSMatcher());
    }

    private static class ProblemMatcher
    extends Matcher {
        ProblemMatcher() {
            super(new String[0], new String[]{"presentingComplaint"}, new String[0]);
        }
    }

    private static class MedicationMatcher
    extends Matcher {
        MedicationMatcher() {
            super(new String[]{"label"}, new String[0], new String[]{"product"});
        }
    }

    private static class InvestigationMatcher
    extends Matcher {
        InvestigationMatcher() {
            super(new String[]{"fileName"}, new String[0], new String[]{"investigationType", "product"});
        }

        @Override
        public boolean match(String search, IMObjectBean bean, boolean searchClinician, boolean searchBatch) {
            if (this.matchesSearch(search, Long.toString(bean.getObject().getId()))) {
                return true;
            }
            return super.match(search, bean, searchClinician, searchBatch);
        }
    }

    private static class NoteMatcher
    extends Matcher {
        NoteMatcher() {
            super(new String[]{"note"});
        }

        @Override
        public boolean match(String search, IMObjectBean bean, boolean searchClinician, boolean searchBatch) {
            boolean result = super.match(search, bean, searchClinician, searchBatch);
            if (!result) {
                result = this.matchesDocument(search, bean);
            }
            return result;
        }
    }

    private static class InvoiceItemMatcher
    extends Matcher {
        InvoiceItemMatcher() {
            super(new String[0], new String[0], new String[]{"product"});
        }
    }

    private static class LetterMatcher
    extends Matcher {
        LetterMatcher() {
            super(new String[]{"fileName"}, new String[0], new String[]{"documentTemplate", "product"});
        }
    }

    private static class FormMatcher
    extends Matcher {
        FormMatcher() {
            super(new String[0], new String[0], new String[]{"documentTemplate", "product"});
        }
    }

    private static class EventMatcher
    extends Matcher {
        EventMatcher() {
            super(new String[]{"title"}, new String[]{"reason"});
        }
    }

    private static class SMSMatcher
    extends Matcher {
        public SMSMatcher() {
            super(new String[]{"phone", "message", "note"}, new String[]{"reason"});
        }
    }

    private static class EmailMatcher
    extends CommunicationMatcher {
        EmailMatcher() {
            super(new String[]{"from", "address", "cc", "bcc", "message", "note"});
        }
    }

    private static class CommunicationMatcher
    extends Matcher {
        CommunicationMatcher() {
            this(new String[]{"address", "message", "note"}, new String[]{"reason"});
        }

        CommunicationMatcher(String[] nodes) {
            this(nodes, new String[]{"reason"});
        }

        CommunicationMatcher(String[] nodes, String[] lookups) {
            super(nodes, lookups, new String[0]);
        }

        @Override
        public boolean match(String search, IMObjectBean bean, boolean searchClinician, boolean searchBatch) {
            if (super.match(search, bean, searchClinician, searchBatch)) {
                return true;
            }
            return this.matchesDocument(search, bean);
        }
    }

    private static class DocumentMatcher
    extends Matcher {
        DocumentMatcher() {
            super(new String[]{"fileName"});
        }

        DocumentMatcher(String[] nodes, String[] lookups, String[] targets) {
            super(nodes, lookups, targets);
        }
    }

    private static class Matcher {
        private final String[] nodes;
        private final String[] lookups;
        private final String[] targets;

        Matcher() {
            this(new String[0]);
        }

        Matcher(String[] nodes) {
            this(nodes, new String[0], new String[0]);
        }

        Matcher(String[] nodes, String[] lookups) {
            this(nodes, lookups, new String[0]);
        }

        Matcher(String[] nodes, String[] lookups, String[] targets) {
            this.nodes = nodes;
            this.lookups = lookups;
            this.targets = targets;
        }

        public boolean match(String search, IMObjectBean bean, boolean searchClinician, boolean searchBatch) {
            if (this.matchesSearch(search, bean.getObject().getDescription())) {
                return true;
            }
            if (this.matchesSearch(search, bean.getDisplayName())) {
                return true;
            }
            if (this.nodes.length != 0 && this.matchesNode(search, bean, this.nodes)) {
                return true;
            }
            if (this.lookups.length != 0 && this.matchesLookup(search, bean, this.lookups)) {
                return true;
            }
            if (this.targets.length != 0 && this.matchesTarget(search, bean, this.targets)) {
                return true;
            }
            if (searchClinician && this.matchesTarget(search, bean, "clinician")) {
                return true;
            }
            return searchBatch && this.matchesTarget(search, bean, "batch");
        }

        boolean matchesNode(String search, IMObjectBean bean, String ... nodes) {
            for (String node : nodes) {
                if (!bean.hasNode(node) || !this.matchesSearch(search, bean.getString(node))) continue;
                return true;
            }
            return false;
        }

        boolean matchesLookup(String search, IMObjectBean bean, String ... nodes) {
            for (String node : nodes) {
                if (!bean.hasNode(node) || !this.matchesName(search, (IMObject)bean.getLookup(node))) continue;
                return true;
            }
            return false;
        }

        boolean matchesTarget(String search, IMObjectBean bean, String ... nodes) {
            for (String node : nodes) {
                if (!bean.hasNode(node) || !this.matchesName(search, bean.getTarget(node))) continue;
                return true;
            }
            return false;
        }

        boolean matchesName(String search, IMObject object) {
            return object != null && this.matchesSearch(search, object.getName());
        }

        boolean matchesSearch(String search, String text) {
            return text != null && text.toLowerCase().contains(search);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean matchesDocument(String search, IMObjectBean bean) {
            DocumentAct act = (DocumentAct)bean.getObject();
            Document document = (Document)IMObjectHelper.getObject((Reference)act.getDocument());
            if (document == null) return false;
            try (InputStream stream = document.getContent();){
                String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (!this.matchesSearch(search, content)) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable exception) {
                log.error("Failed to read document=" + document.getObjectReference() + ": " + exception.getMessage(), exception);
            }
            return false;
        }
    }
}

