/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;

public class ProductTypeSearch
implements Predicate<Act> {
    private final Set<Reference> productTypes;
    private final IArchetypeService service;

    public ProductTypeSearch(Set<Reference> productTypes, IArchetypeService service) {
        this.productTypes = productTypes;
        this.service = service;
    }

    @Override
    public boolean test(Act act) {
        List products;
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.hasNode("product")) {
            Reference product = bean.getTargetRef("product");
            if (product != null) {
                result = this.hasProductType(Collections.singletonList(product));
            }
        } else if (bean.hasNode("products") && !(products = bean.getTargetRefs("products")).isEmpty()) {
            result = this.hasProductType(products);
        }
        return result;
    }

    private boolean hasProductType(List<Reference> products) {
        CriteriaBuilder cb = this.service.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Reference.class);
        Root root = query.from(Product.class, new String[]{"product.*"}).alias("product");
        query.select((Selection)root.join("type").get("target"));
        HashSet<Long> ids = new HashSet<Long>();
        for (Reference reference : products) {
            ids.add(reference.getId());
        }
        query.where((Expression)root.get("id").in(ids));
        List matches = this.service.createQuery(query).getResultList();
        for (Reference reference : matches) {
            if (!this.productTypes.contains(reference)) continue;
            return true;
        }
        return false;
    }
}

