/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentGeneratorFactory;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.AbstractActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.DocumentActActions;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.DialogManager;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;
import org.openvpms.web.workspace.patient.PatientRecordCRUDWindow;
import org.openvpms.web.workspace.patient.history.PatientHistoryActions;

public class AbstractPatientHistoryCRUDWindow
extends AbstractCRUDWindow<Act>
implements PatientRecordCRUDWindow {
    private final DocumentActActions documentActions = new DocumentActActions();
    private Act event;
    private static final String VIEW_ID = "button.view2";
    private static final String MARK_REVIEWED_ID = "button.markReviewed";
    private static final String UNMARK_REVIEWED_ID = "button.unmarkReviewed";
    private static final String EXTERNAL_EDIT_ID = "button.externaledit";

    public AbstractPatientHistoryCRUDWindow(Archetypes<Act> archetypes, PatientHistoryActions actions, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)actions, context, help);
    }

    public void view() {
        Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null) {
            try {
                IMObjectViewerDialog dialog = new IMObjectViewerDialog(this.getContext(), this.getMailContext(), this.getHelpContext());
                if (!DialogManager.isWindowDisplayed()) {
                    dialog.setContextSwitchListener(new ContextSwitchListener(){

                        public void switchTo(IMObject object) {
                            DefaultContextSwitchListener.INSTANCE.switchTo(object);
                        }

                        public void switchTo(String shortName) {
                        }
                    });
                } else {
                    dialog.disableHyperlinks();
                }
                dialog.setObject((IMObject)act);
                dialog.show();
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    @Override
    public void setEvent(Act event) {
        this.event = event;
    }

    @Override
    public Act getEvent() {
        return this.event;
    }

    public Button createViewButton() {
        return ButtonFactory.create((String)VIEW_ID, this::view);
    }

    protected PatientHistoryActions getActions() {
        return (PatientHistoryActions)super.getActions();
    }

    protected void onCreated(Act object) {
        if (object.isA("act.patientMedication")) {
            this.confirmCreation(object, "patient.record.create.medication.title", "patient.record.create.medication.message", "newMedication");
        } else if (object.isA("act.patientInvestigation")) {
            this.confirmCreation(object, "patient.record.create.investigation.title", "patient.record.create.investigation.message", "newInvestigation");
        } else {
            super.onCreated((IMObject)object);
        }
    }

    protected void edit(Act object, List<Selection> path) {
        if (!object.isNew() && object.isA("act.patientMedication")) {
            this.confirmEdit(object, path, "patient.record.edit.medication.title", "patient.record.edit.medication.message");
        } else {
            super.edit((IMObject)object, path);
        }
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createViewButton(), 1);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(VIEW_ID, enable);
        buttons.setEnabled(MARK_REVIEWED_ID, enable && this.getActions().canReview((Act)this.getObject()));
        buttons.setEnabled(UNMARK_REVIEWED_ID, enable && this.getActions().canUnreview((Act)this.getObject()));
        buttons.setEnabled(EXTERNAL_EDIT_ID, enable && this.documentActions.canExternalEdit((Act)this.getObject()));
    }

    protected Button createMarkReviewedButton() {
        return ButtonFactory.create((String)MARK_REVIEWED_ID, (Runnable)this.action("act.patientInvestigation", this::markReviewed, "investigation.reviewed.title"));
    }

    protected Button createUnmarkReviewedButton() {
        return ButtonFactory.create((String)UNMARK_REVIEWED_ID, (Runnable)this.action("act.patientInvestigation", this::unmarkReviewed, "investigation.unreviewed.title"));
    }

    protected void markReviewed(Act investigation) {
        this.getActions().review(investigation);
        this.onRefresh((IMObject)investigation);
    }

    protected void unmarkReviewed(Act investigation) {
        this.getActions().unreview(investigation);
        this.onRefresh((IMObject)investigation);
    }

    protected Button createExternalEditButton() {
        return ButtonFactory.create((String)EXTERNAL_EDIT_ID, this::onExternalEdit);
    }

    protected void onExternalEdit() {
        final DocumentAct act = (DocumentAct)IMObjectHelper.reload((IMObject)this.getObject());
        if (act == null) {
            ErrorDialog.show((String)Messages.format((String)"imobject.noexist", (Object[])new Object[]{this.getArchetypes().getDisplayName()}));
        } else if (act.getDocument() != null) {
            this.documentActions.externalEdit(act);
        } else {
            DocumentGeneratorFactory factory = (DocumentGeneratorFactory)ServiceHelper.getBean(DocumentGeneratorFactory.class);
            DocumentGenerator generator = factory.create(act, this.getContext(), this.getHelpContext(), (DocumentGenerator.Listener)new DocumentGenerator.AbstractListener(){

                public void generated(Document document) {
                    AbstractPatientHistoryCRUDWindow.this.onSaved((IMObject)act, false);
                    if (AbstractPatientHistoryCRUDWindow.this.documentActions.canExternalEdit(act)) {
                        AbstractPatientHistoryCRUDWindow.this.documentActions.externalEdit(act);
                    }
                }
            });
            generator.generate(true, false);
        }
    }

    protected PatientMedicalRecordLinker createMedicalRecordLinker(Act event, Act problem, Act item, Act addendum) {
        return new PatientMedicalRecordLinker(event, problem, item, addendum);
    }

    protected PatientMedicalRecordLinker createMedicalRecordLinker(Act event, Act item) {
        return new PatientMedicalRecordLinker(event, item);
    }

    protected Act createEvent() {
        Act event = (Act)IMObjectCreator.create((String)"act.patientClinicalEvent");
        if (event == null) {
            throw new IllegalStateException("Failed to create act.patientClinicalEvent");
        }
        LayoutContext layoutContext = this.createLayoutContext(this.getHelpContext());
        IMObjectEditor editor = layoutContext.getEditorFactory().create((IMObject)event, layoutContext);
        editor.getComponent();
        if (editor instanceof AbstractActEditor) {
            ((AbstractActEditor)editor).setStatus("COMPLETED");
        }
        editor.save();
        this.setEvent(event);
        return event;
    }

    protected String[] getShortNames(String relationship, boolean includeAddendum, String ... shortNames) {
        Object[] targets = RelationshipHelper.getTargetShortNames((ArchetypeService)ServiceHelper.getArchetypeService(), (String[])new String[]{relationship});
        if (!includeAddendum) {
            targets = (String[])ArrayUtils.removeElement((Object[])targets, (Object)"act.patientClinicalAddendum");
        }
        return (String[])ArrayUtils.addAll((Object[])targets, (Object[])shortNames);
    }

    private void confirmCreation(final Act object, String title, String message, String help) {
        ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)title), Messages.get((String)message), this.getHelpContext().subtopic(help));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                AbstractPatientHistoryCRUDWindow.super.onCreated((IMObject)object);
            }
        });
        dialog.show();
    }

    private void confirmEdit(final Act object, final List<Selection> path, String title, String message) {
        ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)title), Messages.get((String)message));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                AbstractPatientHistoryCRUDWindow.super.edit((IMObject)object, path);
            }
        });
        dialog.show();
    }
}

