/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.act.PagedActHierarchyTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFlattener;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryTableModel;
import org.openvpms.web.workspace.patient.history.ProductTypeSearch;
import org.openvpms.web.workspace.patient.history.TextSearch;

public class AbstractPagedPatientHistoryTableModel
extends PagedActHierarchyTableModel<Act> {
    private final boolean topLevelSortAscending;
    private final AbstractPatientHistoryFlattener flattener;
    private TextSearch textSearch;
    private ProductTypeSearch productTypeSearch;

    public AbstractPagedPatientHistoryTableModel(AbstractPatientHistoryTableModel model, String[] shortNames, boolean topLevelSortAscending, AbstractPatientHistoryFlattener flattener) {
        super((IMObjectTableModel)model, shortNames);
        this.topLevelSortAscending = topLevelSortAscending;
        this.flattener = flattener;
    }

    public void setTextSearch(String search) {
        search = StringUtils.trimToNull((String)search);
        AbstractPatientHistoryTableModel model = this.getModel();
        this.textSearch = search != null ? new TextSearch(search, model.showClinician(), model.showBatches(), model.getService()) : null;
    }

    public void setProductTypes(Set<Reference> productTypes) {
        this.productTypeSearch = productTypes.isEmpty() ? null : new ProductTypeSearch(productTypes, this.getModel().getService());
    }

    public AbstractPatientHistoryTableModel getModel() {
        return (AbstractPatientHistoryTableModel)super.getModel();
    }

    protected List<Act> flattenHierarchy(List<Act> objects, String[] archetypes) {
        return this.flattener.flatten(objects, archetypes, this.getSearch(), this.topLevelSortAscending, this.isSortAscending());
    }

    protected Predicate<Act> getSearch() {
        if (this.productTypeSearch != null && this.textSearch != null) {
            return this.productTypeSearch.and(this.textSearch);
        }
        if (this.productTypeSearch != null) {
            return this.productTypeSearch;
        }
        if (this.textSearch != null) {
            return this.textSearch;
        }
        return null;
    }
}

