/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.estimate;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.workspace.customer.estimate.EstimateQuery;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateResultSet;

public class PatientEstimateQuery
extends EstimateQuery {
    private final Party patient;
    private final CheckBox allPatients;

    public PatientEstimateQuery(Party customer, Party patient) {
        this(customer, patient, false);
    }

    public PatientEstimateQuery(Party customer, Party patient, boolean showAllPatients) {
        super((Entity)customer);
        this.patient = patient;
        if (showAllPatients) {
            this.allPatients = CheckBoxFactory.create((String)"label.allpatients", (boolean)false);
            this.allPatients.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    PatientEstimateQuery.this.onQuery();
                }
            });
        } else {
            this.allPatients = null;
        }
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        if (this.allPatients != null) {
            container.add((Component)this.allPatients);
        }
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        if (this.allPatients != null && this.allPatients.isSelected()) {
            return super.createResultSet(sort);
        }
        return new PatientEstimateResultSet(this.patient, this.getArchetypeConstraint(), this.getParticipantConstraint(), this.getFrom(), this.getTo(), this.getStatuses(), this.getMaxResults(), sort);
    }
}

