/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.estimate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.workspace.customer.estimate.EstimateActRelationshipCollectionEditor;
import org.openvpms.web.workspace.patient.estimate.PatientEstimateItemEditor;

public class PatientEstimateItemRelationshipCollectionEditor
extends EstimateActRelationshipCollectionEditor {
    public PatientEstimateItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context);
    }

    public Party getPatient() {
        return this.getContext().getContext().getPatient();
    }

    public List<Act> getPatientActs() {
        CollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        List objects = editor.getObjects();
        ArrayList<Act> acts = new ArrayList<Act>();
        Party patient = this.getPatient();
        if (patient != null) {
            Reference patientRef = patient.getObjectReference();
            for (IMObject object : objects) {
                Act act = (Act)object;
                IMObjectBean bean = this.getBean((IMObject)act);
                if (!Objects.equals(patientRef, bean.getTargetRef("patient"))) continue;
                acts.add(act);
            }
        }
        return acts;
    }

    @Override
    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return this.initialiseEditor(new PatientEstimateItemEditor((Act)object, (Act)this.getObject(), this.getEditContext(), context));
    }

    protected ResultSet<IMObject> createResultSet() {
        List<Act> acts = this.getPatientActs();
        IMObjectListResultSet set = new IMObjectListResultSet(acts, 15);
        set.sort(new SortConstraint[]{new NodeSortConstraint("startTime", false)});
        return set;
    }
}

