/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.estimate;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.FixedPriceEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.workspace.customer.PriceActItemEditor;
import org.openvpms.web.workspace.customer.charge.ChargeEditContext;
import org.openvpms.web.workspace.customer.estimate.EstimateItemEditor;

public class PatientEstimateItemEditor
extends EstimateItemEditor {
    public PatientEstimateItemEditor(Act act, Act parent, ChargeEditContext context, LayoutContext layoutContext) {
        super(act, parent, context, layoutContext);
        if (act.isNew()) {
            this.initParticipant("patient", (IMObject)layoutContext.getContext().getPatient());
        }
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatioEditor) {
        return new PatientEstimateItemLayoutStrategy(fixedPrice, serviceRatioEditor);
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        ProductParticipationEditor product = this.getProductEditor();
        if (product != null) {
            product.setPatient(this.getPatient());
        }
    }

    private class PatientEstimateItemLayoutStrategy
    extends EstimateItemEditor.EstimateItemLayoutStrategy {
        public PatientEstimateItemLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatioEditor) {
            super(fixedPrice, serviceRatioEditor);
            this.getArchetypeNodes().exclude(new String[]{"patient"});
        }
    }
}

