/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class PatientIdentityEditor {
    private final EntityIdentity identity;
    private final Context context;
    private final HelpContext help;
    private Party patient;

    public PatientIdentityEditor(Party patient, EntityIdentity identity, Context context, HelpContext help) {
        this.patient = patient;
        this.identity = identity;
        this.context = context;
        this.help = help;
    }

    public EditDialog edit(boolean skip) {
        DefaultLayoutContext layout = new DefaultLayoutContext(this.context, this.help.topic((IMObject)this.identity, "edit"));
        IMObjectEditor editor = layout.getEditorFactory().create((IMObject)this.identity, (LayoutContext)layout);
        EditActions actions = EditActions.okCancel().setShowSkip(skip);
        EditDialog dialog = new EditDialog(editor, actions, this.context){

            protected void doSave(IMObjectEditor editor) {
                PatientIdentityEditor.this.patient = (Party)IMObjectHelper.reload((IMObject)PatientIdentityEditor.this.patient);
                if (PatientIdentityEditor.this.patient == null) {
                    throw new IllegalStateException("Patient has been removed");
                }
                PatientIdentityEditor.this.patient.addIdentity(PatientIdentityEditor.this.identity);
                ServiceHelper.getArchetypeService().deriveValues((IMObject)PatientIdentityEditor.this.patient);
                super.doSave(editor);
            }
        };
        dialog.setStyleName("ChildEditDialog");
        return dialog;
    }

    public Party getPatient() {
        return this.patient;
    }

    public static PatientIdentityEditor create(Party patient, String shortName, Context context, HelpContext help) {
        IMObject object = IMObjectCreator.create((String)shortName);
        if (object instanceof EntityIdentity) {
            return new PatientIdentityEditor(patient, (EntityIdentity)object, context, help);
        }
        return null;
    }
}

