/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import java.sql.Date;
import java.util.List;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityRelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.relationship.RelationshipCollectionTargetEditor;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.DatePropertyTransformer;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.BreedEditor;
import org.openvpms.web.workspace.patient.PatientLayoutStrategy;

public class PatientEditor
extends AbstractIMObjectEditor {
    public static final java.util.Date MIN_DATE = Date.valueOf("1900-01-01");
    private final ModifiableListener deceasedListener;
    private final ModifiableListener deceasedDateListener;
    private final RelationshipCollectionTargetEditor customFieldEditor;
    private final BreedEditor breedEditor;
    private boolean showNewBreed;
    private PatientLayoutStrategy strategy;
    private static final String SPECIES = "species";
    private static final String ACTIVE = "active";
    private static final String DECEASED = "deceased";
    private static final String DECEASED_DATE = "deceasedDate";
    private static final String NEW_BREED = "newBreed";

    public PatientEditor(Party patient, IMObject parent, LayoutContext context) {
        super((IMObject)patient, parent, context);
        if (patient.isNew() && !(parent instanceof EntityRelationship)) {
            this.addOwnerRelationship(patient);
        }
        this.getProperty(SPECIES).addModifiableListener(modifiable -> this.speciesChanged());
        Property breed = this.getProperty("breed");
        Property newBreed = this.getProperty(NEW_BREED);
        this.breedEditor = new BreedEditor(breed, (IMObject)patient);
        if (StringUtils.isEmpty((CharSequence)breed.getString()) && !StringUtils.isEmpty((CharSequence)newBreed.getString())) {
            this.showNewBreed = true;
            this.breedEditor.selectNewBreed();
        }
        this.breedEditor.getComponent().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PatientEditor.this.breedChanged();
            }
        });
        Property dateOfBirth = this.getProperty("dateOfBirth");
        java.util.Date maxDate = DateRules.getTomorrow();
        dateOfBirth.setTransformer((PropertyTransformer)new DatePropertyTransformer(dateOfBirth, MIN_DATE, maxDate));
        Property deceasedDate = this.getProperty(DECEASED_DATE);
        deceasedDate.setTransformer((PropertyTransformer)new DatePropertyTransformer(dateOfBirth, MIN_DATE, maxDate));
        this.deceasedDateListener = modifiable -> this.deceasedDateChanged();
        deceasedDate.addModifiableListener(this.deceasedDateListener);
        this.deceasedListener = modifiable -> this.deceasedChanged();
        this.getProperty(DECEASED).addModifiableListener(this.deceasedListener);
        CollectionProperty customField = (CollectionProperty)this.getProperty("customFields");
        this.customFieldEditor = new EntityRelationshipCollectionTargetEditor(customField, (Entity)patient, this.getLayoutContext());
        this.addEditor((Editor)this.breedEditor);
        this.addEditor((Editor)this.customFieldEditor);
        this.createLayoutStrategy();
        this.updateCustomFields();
    }

    public IMObjectEditor newInstance() {
        return new PatientEditor((Party)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        this.strategy = this.createLayoutStrategy(this.breedEditor, this.customFieldEditor);
        return this.strategy;
    }

    protected PatientLayoutStrategy createLayoutStrategy(BreedEditor breedEditor, RelationshipCollectionTargetEditor customFieldEditor) {
        return new PatientLayoutStrategy(breedEditor, customFieldEditor);
    }

    protected boolean doValidation(Validator validator) {
        boolean valid = super.doValidation(validator);
        if (valid) {
            java.util.Date date = this.getDeceasedDate();
            boolean deceased = this.isDeceased();
            if (date != null && !deceased) {
                Property property = this.getProperty(DECEASED);
                validator.add((Modifiable)property, new ValidatorError(property, Messages.get((String)"patient.deceased.required")));
                valid = false;
            } else if (deceased && this.isActive()) {
                Property property = this.getProperty(DECEASED);
                validator.add((Modifiable)property, new ValidatorError(property, Messages.get((String)"patient.deceased.inactive")));
                valid = false;
            }
        }
        return valid;
    }

    private void addOwnerRelationship(Party patient) {
        PatientRules rules;
        Party customer = this.getLayoutContext().getContext().getCustomer();
        if (customer != null && !(rules = (PatientRules)ServiceHelper.getBean(PatientRules.class)).isOwner(customer, patient)) {
            rules.addPatientOwnerRelationship(customer, patient);
        }
    }

    private void updateCustomFields() {
        IMObject object;
        this.getComponent();
        String species = (String)this.getProperty(SPECIES).getValue();
        String shortName = this.getCustomFieldsArchetype(species);
        String currentShortName = null;
        Entity fields = this.getCustomFields();
        if (fields != null) {
            currentShortName = fields.getArchetype();
        }
        if (currentShortName != null && !currentShortName.equals(shortName)) {
            this.customFieldEditor.remove((IMObject)fields);
            this.strategy.removeCustomFields();
        }
        if (shortName != null && !shortName.equals(currentShortName) && (object = IMObjectCreator.create((String)shortName)) instanceof Entity) {
            this.customFieldEditor.add(object);
            this.strategy.addCustomFields();
        }
    }

    private void speciesChanged() {
        this.breedEditor.getComponent().refresh();
        this.breedChanged();
        this.updateCustomFields();
    }

    private void breedChanged() {
        boolean previous = this.showNewBreed;
        if (this.breedEditor.isNewBreed()) {
            this.showNewBreed = true;
        } else {
            Property newBreed = this.getProperty(NEW_BREED);
            newBreed.setValue(null);
            this.showNewBreed = false;
        }
        if (previous != this.showNewBreed) {
            this.onLayout();
            if (this.showNewBreed) {
                this.breedEditor.selectNewBreed();
                this.getEditor(NEW_BREED).getFocusGroup().setFocus();
            } else {
                this.breedEditor.getFocusGroup().setFocus();
            }
        }
    }

    private void setDeceased(boolean deceased) {
        Property property = this.getProperty(DECEASED);
        try {
            property.removeModifiableListener(this.deceasedListener);
            property.setValue((Object)deceased);
            this.setActive(!deceased);
        }
        finally {
            property.addModifiableListener(this.deceasedListener);
        }
    }

    private boolean isDeceased() {
        return this.getProperty(DECEASED).getBoolean();
    }

    private void setActive(boolean active) {
        this.getProperty(ACTIVE).setValue((Object)active);
    }

    private boolean isActive() {
        return this.getProperty(ACTIVE).getBoolean();
    }

    private void setDeceasedDate(java.util.Date date) {
        Property property = this.getProperty(DECEASED_DATE);
        try {
            property.removeModifiableListener(this.deceasedDateListener);
            property.setValue((Object)date);
            this.setActive(date == null);
        }
        finally {
            property.addModifiableListener(this.deceasedDateListener);
        }
    }

    private java.util.Date getDeceasedDate() {
        Property deceasedDate = this.getProperty(DECEASED_DATE);
        return deceasedDate.getDate();
    }

    private void deceasedDateChanged() {
        java.util.Date date = this.getDeceasedDate();
        this.setDeceased(date != null);
    }

    private void deceasedChanged() {
        boolean deceased = this.isDeceased();
        this.setDeceasedDate(deceased ? new java.util.Date() : null);
    }

    private String getCustomFieldsArchetype(String species) {
        Lookup lookup;
        String result = null;
        if (species != null && (lookup = ServiceHelper.getLookupService().getLookup("lookup.species", species)) != null) {
            IMObjectBean bean = this.getBean((IMObject)lookup);
            result = bean.getString("customFields");
        }
        return result;
    }

    private Entity getCustomFields() {
        List result = this.customFieldEditor.getObjects();
        return !result.isEmpty() ? (Entity)result.get(0) : null;
    }
}

