/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.paymentprocessor.transaction.Payment;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.sms.SMSDialog;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.mail.EmailTemplateEvaluator;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.paymentprocessor.PaymentProcessorSMSEvaluator;
import org.openvpms.web.workspace.customer.CustomerMailContext;

public class PaymentProcessorStatusDialog
extends MessageDialog {
    private final FinancialAct transaction;
    private final String url;
    private final LayoutContext context;
    private final ArchetypeService service;
    private final Entity processor;
    private static final String MAIL_ID = "button.mail";
    private static final String SMS_ID = "button.sms.send";

    private PaymentProcessorStatusDialog(Entity paymentProcessor, FinancialAct transaction, String message, String url, ArchetypeService service, LayoutContext context) {
        super(paymentProcessor.getName(), message, OK);
        this.transaction = transaction;
        this.service = service;
        this.url = url;
        this.processor = paymentProcessor;
        this.context = context;
        if ("SUBMITTED".equals(transaction.getStatus()) && url != null) {
            this.addButton(MAIL_ID);
            this.addButton(SMS_ID);
        }
    }

    public static PaymentProcessorStatusDialog create(Entity paymentProcessor, Transaction transaction, FinancialAct act, LayoutContext context, boolean sendLink) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        StringBuilder builder = new StringBuilder();
        Transaction.Status status = transaction.getStatus();
        if (status == Transaction.Status.SUBMITTED) {
            if (transaction instanceof Payment) {
                builder.append(Messages.format((String)"customer.payment.pp.payment.SUBMITTED", (Object[])new Object[]{paymentProcessor.getName()}));
            } else {
                builder.append(Messages.format((String)"customer.payment.pp.refund.SUBMITTED", (Object[])new Object[]{paymentProcessor.getName()}));
            }
            builder.append("\n\n");
            String email = transaction.getEmail();
            if (email != null) {
                builder.append(Messages.format((String)"customer.payment.pp.email", (Object[])new Object[]{paymentProcessor.getName(), email}));
            } else {
                builder.append(Messages.format((String)"customer.payment.pp.sendLink", (Object[])new Object[]{paymentProcessor.getName()}));
            }
        } else {
            String message;
            String key = "customer.payment.pp." + status;
            String statusMessage = status == Transaction.Status.ERROR ? ((message = transaction.getMessage()) == null ? Messages.get((String)(key + ".nomessage")) : Messages.format((String)key, (Object[])new Object[]{message})) : Messages.format((String)key, (Object[])new Object[]{paymentProcessor.getName()});
            builder.append(statusMessage);
        }
        String message = builder.toString();
        PaymentProcessorStatusDialog dialog = new PaymentProcessorStatusDialog(paymentProcessor, act, message, transaction.getUrl(), (ArchetypeService)service, context);
        if (sendLink) {
            dialog.setTitle(Messages.get((String)"customer.payment.pp.sendLink.title"));
        }
        return dialog;
    }

    protected void onButton(String button) {
        if (button.equals(MAIL_ID)) {
            this.onMail();
        } else if (button.equals(SMS_ID)) {
            this.onSMS();
        } else {
            super.onButton(button);
        }
    }

    private void onMail() {
        Object mailContext = this.context.getMailContext();
        if (!(mailContext instanceof CustomerMailContext)) {
            mailContext = new CustomerMailContext(this.context.getContext());
        }
        MailDialog dialog = new MailDialog(mailContext, null, this.context);
        dialog.show();
        MailEditor mailEditor = dialog.getMailEditor();
        EmailTemplate template = this.getEmailTemplate();
        String subject = null;
        String message = null;
        if (template != null) {
            try {
                LocalContext localContext = LocalContext.copy((Context)this.context.getContext());
                IMObjectBean bean = this.service.getBean((IMObject)this.transaction);
                localContext.setLocation((Party)bean.getTarget("location", Party.class));
                localContext.setCustomer((Party)bean.getTarget("customer", Party.class));
                EmailTemplateEvaluator evaluator = (EmailTemplateEvaluator)ServiceHelper.getBean(EmailTemplateEvaluator.class);
                subject = evaluator.getSubject(template, (Object)this.transaction, (Context)localContext);
                message = evaluator.getMessage(template, (Object)this.transaction, (Context)localContext);
            }
            catch (Exception exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        if (subject == null) {
            String key = this.isPayment() ? "customer.payment.pp.mail.paymentSubject" : "customer.payment.pp.mail.refundSubject";
            subject = Messages.format((String)key, (Object[])new Object[]{this.processor.getName()});
        }
        if (message == null) {
            String description = this.transaction.getDescription();
            if (description == null) {
                description = "";
            }
            message = Messages.format((String)"customer.payment.pp.mail.body", (Object[])new Object[]{this.processor.getName(), description, this.url});
        }
        mailEditor.setSubject(subject);
        mailEditor.setMessage(message);
    }

    private void onSMS() {
        List contacts = ContactHelper.getSMSContacts((Party)this.context.getContext().getCustomer());
        SMSDialog dialog = new SMSDialog(contacts, this.context.getContext(), this.context.getHelpContext());
        dialog.show();
        dialog.setMessage(this.getSMSMessage());
    }

    private String getSMSMessage() {
        String result = null;
        Entity template = this.getSMSTemplate();
        if (template != null) {
            try {
                PaymentProcessorSMSEvaluator evaluator = new PaymentProcessorSMSEvaluator(this.context.getContext().getPractice(), (SMSTemplateEvaluator)ServiceHelper.getBean(SMSTemplateEvaluator.class), this.service, ServiceHelper.getLookupService());
                result = evaluator.evaluate(template, this.transaction);
            }
            catch (Exception exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        if (result == null) {
            String description = this.transaction.getDescription();
            if (description == null) {
                description = "";
            }
            result = Messages.format((String)"customer.payment.pp.sms", (Object[])new Object[]{this.processor.getName(), description, this.url});
        }
        return result;
    }

    private EmailTemplate getEmailTemplate() {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)this.transaction, this.context.getContext());
        DocumentTemplate template = locator.getTemplate();
        return template != null ? template.getEmailTemplate() : null;
    }

    private Entity getSMSTemplate() {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator((IMObject)this.transaction, this.context.getContext());
        DocumentTemplate template = locator.getTemplate();
        return template != null ? template.getSMSTemplate() : null;
    }

    private boolean isPayment() {
        return this.transaction.isA("act.paymentProcessorPayment");
    }
}

