/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.List;
import java.util.stream.Collectors;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.helper.sort.IMObjectSorter;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessors;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.AbstractRemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.ActCollectionResultSetFactory;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.payment.AbstractCustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.PaymentItemTableModel;
import org.openvpms.web.workspace.customer.payment.PaymentProcessorPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentItemEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentItemRelationshipCollectionEditor
extends ActRelationshipCollectionEditor {
    private final PaymentProcessors processors = (PaymentProcessors)ServiceHelper.getBean(PaymentProcessors.class);
    private final EditorQueue queue;
    private Entity paymentProcessor;
    private AbstractCustomerPaymentEditor parent;
    private static final String DEFAULT_PAYMENT_TYPE = "defaultPaymentType";
    private static final Logger log = LoggerFactory.getLogger(PaymentProcessorPaymentItemEditor.class);

    public PaymentItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context, (CollectionResultSetFactory)new CollectionFactory());
        this.queue = new DefaultEditorQueue(context.getContext());
        this.setRemoveConfirmationHandler((RemoveConfirmationHandler)new RemoveHandler());
    }

    public void setParent(AbstractCustomerPaymentEditor parent) {
        this.parent = parent;
    }

    public EditorQueue getQueue() {
        return this.queue;
    }

    public IMObjectEditor add(String shortName) {
        IMObjectEditor editor = super.add(shortName);
        if (editor != null) {
            editor.getComponent();
            editor.clearModified();
        }
        return editor;
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        IMObjectEditor editor = super.createEditor(object, context);
        this.initialise(editor);
        return editor;
    }

    public List<PaymentItemEditor> getPaymentItemEditors() {
        return this.getCurrentActs().stream().map(arg_0 -> ((PaymentItemRelationshipCollectionEditor)this).getEditor(arg_0)).filter(editor -> editor instanceof PaymentItemEditor).map(editor -> (PaymentItemEditor)editor).collect(Collectors.toList());
    }

    protected void initialise(IMObjectEditor editor) {
        if (editor instanceof PaymentProcessorPaymentItemEditor) {
            PaymentProcessorPaymentItemEditor paymentItemEditor = (PaymentProcessorPaymentItemEditor)editor;
            if (paymentItemEditor.getPaymentProcessor() == null) {
                paymentItemEditor.setPaymentProcessor(this.paymentProcessor);
            }
            paymentItemEditor.setPaymentEditor(this.parent);
        }
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.queue.isComplete() && this.validateSplitTransactions(validator);
    }

    protected boolean validateSplitTransactions(Validator validator) {
        List<PaymentItemEditor> paymentItemEditors = this.getPaymentItemEditors();
        if (paymentItemEditors.size() > 1) {
            paymentItemEditors.stream().filter(editor -> !editor.supportsSplitTransactions()).findFirst().ifPresent(editor -> {
                boolean isPayment = this.getObject().isA("act.customerAccountPayment");
                String key = isPayment ? "customer.payment.splitPaymentUnsupported" : "customer.payment.splitRefundUnsupported";
                validator.add((Modifiable)this, Messages.format((String)key, (Object[])new Object[]{editor.getDisplayName()}));
            });
        }
        return validator.isValid();
    }

    protected Component doLayout(LayoutContext context) {
        Component component = super.doLayout(context);
        String archetype = this.getDefaultArchetype();
        if (archetype != null) {
            this.setArchetype(archetype);
        }
        return component;
    }

    protected boolean showPreviousNext() {
        return false;
    }

    protected void enableNavigation(boolean enable) {
        boolean enableAdd = enable;
        if (enable) {
            enableAdd = this.getPaymentItemEditors().stream().allMatch(PaymentItemEditor::supportsSplitTransactions);
        }
        super.enableNavigation(enable, enableAdd);
    }

    protected void addArchetypeSelector(ButtonRow buttons, FocusGroup focus) {
        ArchetypeService service = this.getService();
        String[] range = this.getArchetypes();
        ButtonGroup group = new ButtonGroup();
        String defaultArchetype = this.getDefaultArchetype();
        if (defaultArchetype == null && range.length > 0) {
            defaultArchetype = range[0];
        }
        for (String archetype : range) {
            if (TypeHelper.isA((String)archetype, (String[])new String[]{"act.customerAccountPaymentPP", "act.customerAccountRefundPP"})) {
                this.addPaymentProcessors(archetype, buttons, group);
                continue;
            }
            String displayName = DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)service);
            RadioButton button = ButtonFactory.text((String)displayName, (ButtonGroup)group, () -> this.onArchetypeSelected(archetype, null));
            if (archetype.equals(defaultArchetype)) {
                this.setArchetype(archetype);
                button.setSelected(true);
            }
            buttons.addButton(button);
        }
    }

    protected String[] getArchetypes() {
        return DescriptorHelper.getShortNames((String[])this.getCollectionPropertyEditor().getArchetypeRange(), (boolean)false, (ArchetypeService)this.getService());
    }

    protected IMObjectEditor onArchetypeSelected(String archetype, Entity paymentProcessor) {
        IMObject object;
        IMObjectEditor result = null;
        this.setArchetype(archetype);
        this.paymentProcessor = paymentProcessor;
        IMObjectEditor currentEditor = this.getCurrentEditor();
        IMObject iMObject = object = currentEditor != null ? currentEditor.getObject() : null;
        if (object != null && object.isNew() && !currentEditor.isModified()) {
            this.remove(object);
        }
        if (this.checkSplitTransactions(paymentProcessor)) {
            result = this.onAdd();
        }
        return result;
    }

    private boolean checkSplitTransactions(Entity paymentProcessor) {
        boolean valid = true;
        List<PaymentItemEditor> editors = this.getPaymentItemEditors();
        if (paymentProcessor != null && !editors.isEmpty()) {
            this.splitTransactionUnsupported(paymentProcessor.getName());
            valid = false;
        } else {
            for (PaymentItemEditor editor : editors) {
                if (editor.supportsSplitTransactions()) continue;
                this.splitTransactionUnsupported(editor.getDisplayName());
                valid = false;
                break;
            }
        }
        return valid;
    }

    private void splitTransactionUnsupported(String displayName) {
        boolean isPayment = this.getObject().isA("act.customerAccountPayment");
        String key = isPayment ? "customer.payment.splitPaymentUnsupported" : "customer.payment.splitRefundUnsupported";
        InformationDialog.show((String)Messages.format((String)key, (Object[])new Object[]{displayName}));
    }

    private void addPaymentProcessors(String archetype, ButtonRow buttons, ButtonGroup group) {
        boolean refund = TypeHelper.isA((String)archetype, (String[])new String[]{"act.customerAccountRefundPP"});
        List configs = ((PaymentProcessors)ServiceHelper.getBean(PaymentProcessors.class)).getPaymentProcessors();
        if (!configs.isEmpty()) {
            configs.sort(IMObjectSorter.getNameComparator().thenComparing(IMObjectSorter.getIdComparator()));
            for (Entity config : configs) {
                if (refund && !this.paymentProcessorSupportsRefunds(config)) continue;
                RadioButton button = ButtonFactory.text((String)config.getName(), (ButtonGroup)group, () -> this.onArchetypeSelected(archetype, config));
                buttons.addButton(button);
            }
        }
    }

    private boolean paymentProcessorSupportsRefunds(Entity config) {
        boolean result = false;
        try {
            PaymentProcessorService processor = this.processors.getPaymentProcessor(config);
            result = processor.getRefundCapabilities().isSupported();
        }
        catch (Throwable exception) {
            log.debug("Failed to retrieve PaymentProcessorService for {} ({}): {}", new Object[]{config.getName(), config.getId(), exception.getMessage(), exception});
        }
        return result;
    }

    private String getDefaultArchetype() {
        IMObjectBean bean;
        String archetype = null;
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        Party practice = practiceService.getPractice();
        if (practice != null && (archetype = (bean = this.getBean((IMObject)practice)).getString(DEFAULT_PAYMENT_TYPE)) != null && this.getObject().isA("act.customerAccountRefund")) {
            archetype = ((CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class)).getReversalArchetype(archetype);
        }
        return archetype;
    }

    private static class CollectionFactory
    extends ActCollectionResultSetFactory {
        private CollectionFactory() {
        }

        public IMTableModel<IMObject> createTableModel(CollectionPropertyEditor property, IMObject parent, LayoutContext context) {
            context = new DefaultLayoutContext(context);
            context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(context));
            PaymentItemTableModel model = new PaymentItemTableModel(property.getArchetypeRange(), context);
            TableColumn column = model.getColumnModel().getColumn(0);
            model.setDefaultSortAscending(!(column instanceof DescriptorTableColumn) || !((DescriptorTableColumn)column).getName().equals("startTime"));
            model.setDefaultSortColumn(column.getModelIndex());
            return model;
        }
    }

    private static class RemoveHandler
    extends AbstractRemoveConfirmationHandler {
        private RemoveHandler() {
        }

        protected void confirmRemove(IMObject object, IMObjectCollectionEditor collection) {
            PaymentItemRelationshipCollectionEditor editor = (PaymentItemRelationshipCollectionEditor)collection;
            IMObjectEditor itemEditor = editor.getEditor(object);
            if (itemEditor instanceof TransactionPaymentItemEditor) {
                TransactionPaymentItemEditor transactionPaymentItemEditor = (TransactionPaymentItemEditor)itemEditor;
                Deletable deletable = transactionPaymentItemEditor.getDeletable();
                if (deletable.canDelete()) {
                    super.confirmRemove(object, collection);
                } else {
                    String displayName = transactionPaymentItemEditor.getTransactionDisplayName();
                    if (transactionPaymentItemEditor.canCancelTransaction()) {
                        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("customer.payment.delete.cancel.title", new Object[]{displayName})).messageKey("customer.payment.delete.cancel.message", new Object[]{displayName})).yesNo()).yes(() -> {
                            transactionPaymentItemEditor.cancelTransaction();
                            Deletable postCancel = transactionPaymentItemEditor.getDeletable();
                            if (postCancel.canDelete()) {
                                this.apply(object, collection);
                            } else {
                                this.cannotDelete(postCancel, displayName);
                                this.cancelRemove(collection);
                            }
                        })).no(() -> this.cancelRemove(collection))).show();
                    } else {
                        this.cannotDelete(deletable, displayName);
                        this.cancelRemove(collection);
                    }
                }
            } else {
                super.confirmRemove(object, collection);
            }
        }

        private void cannotDelete(Deletable status, String displayName) {
            String title = Messages.format((String)"imobject.collection.delete.title", (Object[])new Object[]{displayName});
            InformationDialog.show((String)title, (String)status.getReason());
        }
    }
}

