/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.web.component.im.delete.ActDeletionHandler;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.transaction.PlatformTransactionManager;

public class PaymentDeletionHandler
extends ActDeletionHandler<FinancialAct> {
    private final CustomerAccountRules rules;

    public PaymentDeletionHandler(FinancialAct object, IMObjectEditorFactory factory, PlatformTransactionManager transactionManager, IArchetypeRuleService service, CustomerAccountRules rules) {
        super((Act)object, factory, transactionManager, service);
        this.rules = rules;
    }

    public Deletable getDeletable() {
        Deletable result = super.getDeletable();
        if (result.canDelete()) {
            FinancialAct object = (FinancialAct)this.getObject();
            if (this.rules.hasApprovedEFTPOSTransaction(object)) {
                result = Deletable.no((String)Messages.format((String)"customer.payment.delete.approvedEFT", (Object[])new Object[]{this.getDisplayName()}));
            } else if (this.rules.hasOutstandingEFTPOSTransaction(object, true)) {
                result = Deletable.no((String)Messages.format((String)"customer.payment.delete.outstandingEFT", (Object[])new Object[]{this.getDisplayName()}));
            } else if (this.rules.hasCompletedPaymentProcessorItem(object)) {
                result = Deletable.no((String)Messages.format((String)"customer.payment.delete.completedPP", (Object[])new Object[]{this.getDisplayName()}));
            }
        }
        return result;
    }
}

