/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionListener;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.eftpos.internal.service.EFTPOSServices;
import org.openvpms.eftpos.internal.terminal.TerminalImpl;
import org.openvpms.eftpos.internal.transaction.EFTPOSTransactionFactory;
import org.openvpms.eftpos.internal.transaction.PaymentImpl;
import org.openvpms.eftpos.internal.transaction.RefundImpl;
import org.openvpms.eftpos.service.EFTPOSService;
import org.openvpms.eftpos.service.ManagedTransactionDisplay;
import org.openvpms.eftpos.service.TransactionDisplay;
import org.openvpms.eftpos.service.WebTransactionDisplay;
import org.openvpms.eftpos.terminal.Terminal;
import org.openvpms.eftpos.transaction.Payment;
import org.openvpms.eftpos.transaction.Refund;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.payment.WebEFTPaymentDialog;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.EFTHelper;
import org.openvpms.web.workspace.customer.payment.EFTPaymentDialog;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentLayoutStrategy;

public class EFTPaymentItemEditor
extends TransactionPaymentItemEditor {
    private final Entity noTerminal;
    private final EFTPOSTransactionFactory transactionFactory;
    private final LocationRules locationRules;
    private final Entity initialTill;
    private final Entity initialTerminal;
    private List<Entity> terminals = Collections.emptyList();
    private SelectField terminalSelector;
    private Entity lastTerminal;
    private static final String TERMINAL = "terminal";
    private static final String CASHOUT = "cashout";

    public EFTPaymentItemEditor(FinancialAct act, FinancialAct parent, LayoutContext context) {
        super(act, parent, context);
        IMObjectBean bean = this.getBean((IMObject)parent);
        this.initialTill = (Entity)context.getCache().get(bean.getTargetRef("till"));
        this.initialTerminal = context.getContext().getTerminal();
        this.noTerminal = new org.openvpms.component.business.domain.im.common.Entity();
        this.noTerminal.setName(Messages.get((String)"customer.payment.eft.noterminalname"));
        this.transactionFactory = (EFTPOSTransactionFactory)ServiceHelper.getBean(EFTPOSTransactionFactory.class);
        this.locationRules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        this.updateTransactionStatus();
        this.setTill(this.initialTill);
    }

    public BigDecimal getCashout() {
        return this.getProperty(CASHOUT).getBigDecimal(BigDecimal.ZERO);
    }

    public void setTill(Entity till) {
        List<Object> list = this.terminals = till != null ? this.locationRules.getTerminals(till) : Collections.emptyList();
        if (!this.terminals.isEmpty()) {
            this.terminals.sort(IMObjectSorter.getNameComparator((boolean)true));
        }
        if (this.isComplete() || this.terminals.isEmpty()) {
            this.terminalSelector = null;
        } else {
            Entity terminal = null;
            if (this.lastTerminal != null && !this.terminals.contains(this.lastTerminal)) {
                this.lastTerminal = null;
            }
            if (this.lastTerminal != null) {
                terminal = this.lastTerminal;
            } else if (this.initialTerminal != null && this.terminals.contains(this.initialTerminal)) {
                terminal = this.initialTerminal;
            } else if (this.initialTerminal == null && Objects.equals(till, this.initialTill)) {
                terminal = this.noTerminal;
            }
            if (terminal == null) {
                terminal = this.terminals.get(0);
            }
            this.terminalSelector = this.createTerminalSelector(terminal);
        }
        if (this.getView().hasComponent()) {
            this.refreshLayout();
        }
    }

    @Override
    public boolean requiresTransaction() {
        boolean result = this.isComplete() ? false : this.hasTransaction() || this.getTerminal() != null || !this.terminals.isEmpty();
        return result;
    }

    @Override
    protected String getTransactionDisplayName() {
        return "EFTPOS";
    }

    @Override
    protected void performTransaction(TransactionPaymentItemEditor.TransactionState state, Runnable listener) {
        boolean notifyListener = false;
        if (this.noTerminalTransactionRequired()) {
            this.createNoTerminalTransaction(state.getSequence());
            notifyListener = true;
        } else {
            FinancialAct act = state.getAct();
            Terminal terminal = this.getTerminal(state);
            if (terminal == null) {
                ErrorHelper.show((String)EFTHelper.getDialogTitle((IMObject)this.getObject()), (String)Messages.get((String)"customer.payment.eft.noterminal"));
            } else {
                EFTPOSService service = ((EFTPOSServices)ServiceHelper.getBean(EFTPOSServices.class)).getService((Entity)terminal);
                if (service.isAvailable(terminal)) {
                    boolean isNew = false;
                    if (act == null) {
                        isNew = true;
                        act = this.createTransactionAct(terminal, state.getSequence());
                    }
                    this.performTransaction((Act)act, isNew, service, listener);
                } else {
                    ErrorHelper.show((String)EFTHelper.getDialogTitle((IMObject)this.getObject()), (String)Messages.format((String)"customer.payment.eft.terminalunavailable", (Object[])new Object[]{terminal.getName()}));
                }
            }
        }
        this.refreshLayout();
        if (notifyListener) {
            listener.run();
        }
    }

    @Override
    protected Deletable getDeletable(FinancialAct transaction) {
        Deletable result;
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        if (Transaction.Status.NO_TERMINAL != status && Transaction.Status.DECLINED != status && Transaction.Status.ERROR != status) {
            String reason = Transaction.Status.APPROVED == status ? Messages.format((String)"customer.payment.delete.approvedEFT", (Object[])new Object[]{this.getDisplayName()}) : Messages.format((String)"customer.payment.delete.outstandingEFT", (Object[])new Object[]{this.getDisplayName()});
            result = Deletable.no((String)reason);
        } else {
            result = Deletable.yes();
        }
        return result;
    }

    protected Entity getTerminal() {
        Entity result = null;
        if (this.terminalSelector != null) {
            Entity selected = (Entity)this.terminalSelector.getSelectedItem();
            result = selected != this.noTerminal ? selected : null;
        }
        return result;
    }

    protected Terminal getTerminal(TransactionPaymentItemEditor.TransactionState state) {
        Entity entity = null;
        if (state.getAct() != null) {
            IMObjectBean bean = this.getBean((IMObject)state.getAct());
            entity = (Entity)bean.getTarget(TERMINAL, Entity.class);
        }
        if (entity == null) {
            entity = this.getTerminal();
        }
        return entity != null ? new TerminalImpl(entity, (ArchetypeService)this.getService()) : null;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new EFTPaymentEditLayoutStrategy();
    }

    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        PropertySetBuilder builder = new PropertySetBuilder(object, archetype, variables);
        builder.mutable("amount");
        if (object.isA("act.customerAccountPaymentEFT")) {
            builder.mutable(CASHOUT);
        }
        return builder.build();
    }

    protected boolean noTerminalTransactionRequired() {
        boolean result = false;
        if (this.terminalSelector != null) {
            Entity selected = (Entity)this.terminalSelector.getSelectedItem();
            result = selected == this.noTerminal;
        } else if (this.hasTransaction() && this.terminals.isEmpty()) {
            result = true;
        }
        return result;
    }

    @Override
    protected boolean updateTransactionStatus(FinancialAct transaction, boolean complete) {
        boolean changed = super.updateTransactionStatus(transaction, complete);
        if (transaction != null) {
            IMObjectBean bean = this.getBean((IMObject)transaction);
            this.lastTerminal = (Entity)bean.getTarget(TERMINAL, Entity.class);
        } else {
            this.lastTerminal = null;
        }
        if (complete) {
            this.terminalSelector = null;
        }
        if (this.getObject().isA("act.customerAccountPaymentEFT")) {
            changed |= this.updateReadOnly(CASHOUT, complete);
        }
        return changed;
    }

    @Override
    protected boolean isNewTransactionRequired(Act transaction) {
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        return status == Transaction.Status.ERROR || status == Transaction.Status.DECLINED;
    }

    @Override
    protected boolean isComplete(FinancialAct transaction) {
        Transaction.Status status = Transaction.Status.valueOf((String)transaction.getStatus());
        return status == Transaction.Status.APPROVED || status == Transaction.Status.NO_TERMINAL;
    }

    protected Editors getEditors() {
        return super.getEditors();
    }

    private SelectField createTerminalSelector(Entity defaultTerminal) {
        ArrayList<Entity> list = new ArrayList<Entity>(this.terminals);
        list.add(this.noTerminal);
        IMObjectListModel model = new IMObjectListModel(list, false, false);
        SelectField field = SelectFieldFactory.create((ListModel)model);
        field.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        field.setSelectedItem((Object)defaultTerminal);
        field.addActionListener((ActionListener & Serializable)e -> {
            Entity selected = (Entity)field.getSelectedItem();
            if (selected == this.noTerminal) {
                selected = null;
            }
            this.getLayoutContext().getContext().setTerminal(selected);
        });
        return field;
    }

    private void performTransaction(Act act, boolean isNew, EFTPOSService service, Runnable listener) {
        Object dialog;
        TransactionDisplay display;
        PaymentImpl transaction;
        boolean isPayment = act.isA("act.EFTPOSPayment");
        DomainService domainService = (DomainService)ServiceHelper.getBean(DomainService.class);
        PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        if (isPayment) {
            PaymentImpl payment;
            transaction = payment = new PaymentImpl(act, (ArchetypeService)this.getService(), domainService, practiceService);
            display = isNew ? service.pay((Payment)payment) : service.resume((Payment)payment);
        } else {
            RefundImpl refund = new RefundImpl(act, (ArchetypeService)this.getService(), domainService, practiceService);
            transaction = refund;
            display = isNew ? service.refund((Refund)refund) : service.resume((Refund)refund);
        }
        if (display instanceof WebTransactionDisplay) {
            dialog = new WebEFTPaymentDialog((WebTransactionDisplay)display, this.getHelpContext());
        } else if (display instanceof ManagedTransactionDisplay) {
            User user = this.getLayoutContext().getContext().getUser();
            dialog = new EFTPaymentDialog(act, (ManagedTransactionDisplay)display, user, this.getLayoutContext().getContext(), this.getHelpContext());
            dialog.setDefaultCloseAction("cancel");
            dialog.setCancelListener(arg_0 -> this.lambda$performTransaction$0((Transaction)transaction, arg_0));
        } else if (display == null) {
            String title = EFTHelper.getDialogTitle(isPayment);
            dialog = transaction.getStatus() == Transaction.Status.APPROVED ? new InformationDialog(title, Messages.get((String)"customer.payment.eft.approved")) : (transaction.getStatus() == Transaction.Status.DECLINED ? new InformationDialog(title, Messages.get((String)"customer.payment.eft.declined")) : new ErrorDialog("Unexpected error"));
        } else {
            throw new IllegalStateException("EFTPOS service " + service.getClass().getName() + " returned unsupported transaction display: " + display.getClass().getName());
        }
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener((Transaction)transaction, listener){
            final /* synthetic */ Transaction val$transaction;
            final /* synthetic */ Runnable val$listener;
            {
                this.val$transaction = transaction;
                this.val$listener = runnable;
            }

            public void onClose(WindowPaneEvent event) {
                EFTPaymentItemEditor.this.refreshLayout();
                if (this.val$transaction.getStatus() == Transaction.Status.APPROVED) {
                    this.val$listener.run();
                }
            }
        });
        dialog.show();
    }

    private void confirmCloseEFTDialog(Transaction transaction, Vetoable vetoable) {
        if (!transaction.isComplete()) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(EFTHelper.getDialogTitle(transaction))).message(Messages.get((String)"customer.payment.eft.incomplete"))).yesNo()).yes(() -> vetoable.veto(false))).defaultListener(s -> vetoable.veto(true))).show();
        } else {
            vetoable.veto(false);
        }
    }

    private FinancialAct createTransactionAct(Terminal terminal, int sequence) {
        boolean isPayment = this.getObject().isA("act.customerAccountPaymentEFT");
        FinancialAct parent = (FinancialAct)this.getParent();
        BigDecimal amount = this.getAmount();
        Party location = this.getLayoutContext().getContext().getLocation();
        FinancialAct act = isPayment ? this.transactionFactory.createPayment(parent, amount, this.getCashout(), (Entity)terminal, location) : this.transactionFactory.createRefund(parent, amount, (Entity)terminal, location);
        act.setStatus("IN_PROGRESS");
        this.addTransaction(act, sequence);
        return act;
    }

    private void createNoTerminalTransaction(int sequence) {
        boolean isPayment = this.getObject().isA("act.customerAccountPaymentEFT");
        FinancialAct parent = (FinancialAct)this.getParent();
        BigDecimal amount = this.getAmount();
        Party location = this.getLayoutContext().getContext().getLocation();
        FinancialAct act = isPayment ? this.transactionFactory.createNoTerminalPayment(parent, amount, this.getCashout(), location) : this.transactionFactory.createNoTerminalRefund(parent, amount, location);
        this.addTransaction(act, sequence);
    }

    private /* synthetic */ void lambda$performTransaction$0(Transaction transaction, Vetoable action) {
        this.confirmCloseEFTDialog(transaction, action);
    }

    private class EFTPaymentEditLayoutStrategy
    extends TransactionPaymentLayoutStrategy {
        private EFTPaymentEditLayoutStrategy() {
        }

        protected void doSimpleLayout(IMObject object, IMObject parent, List<Property> properties, Component container, LayoutContext context) {
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            super.doSimpleLayout(object, parent, properties, (Component)row, context);
            if (EFTPaymentItemEditor.this.terminalSelector != null) {
                row.add((Component)LabelFactory.create((String)"customer.payment.eft.terminal"));
                row.add((Component)EFTPaymentItemEditor.this.terminalSelector);
            }
            container.add((Component)row);
        }
    }
}

