/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.edit.payment.PaymentEditor;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreationListener;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.EFTPaymentItemEditor;
import org.openvpms.web.workspace.customer.payment.PaymentException;
import org.openvpms.web.workspace.customer.payment.PaymentItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.payment.PaymentStatus;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentItemEditor;

public abstract class AbstractCustomerPaymentEditor
extends PaymentEditor {
    private final PaymentStatus status;
    private final SimpleProperty invoiceAmount;
    private final CustomerAccountRules rules;
    private final BigDecimal reversalAmount;
    private BigDecimal expectedAmount;
    private Entity eftTill;
    private boolean addDefaultItem;

    public AbstractCustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        this(act, parent, context, act.isNew());
    }

    public AbstractCustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context, boolean addDefaultItem) {
        super(act, parent, context);
        Entity till;
        this.status = new PaymentStatus(this.getProperty("status"), act);
        this.invoiceAmount = this.createProperty("invoiceAmount", "customer.payment.currentInvoice");
        this.rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        this.addDefaultItem = addDefaultItem;
        FinancialAct reversal = (FinancialAct)this.getBean((IMObject)act).getSource("reverses", FinancialAct.class);
        this.reversalAmount = reversal != null ? reversal.getTotal() : null;
        this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
        this.initParticipant("location", (IMObject)context.getContext().getLocation());
        if (!this.status.isReadOnly()) {
            this.addEditor((Editor)this.status.getEditor());
        }
        this.getItems().setCreationListener(new IMObjectCreationListener(){

            public void created(IMObject object) {
                AbstractCustomerPaymentEditor.this.onCreated((FinancialAct)object);
            }
        });
        if (!act.isNew() && (till = this.getTill()) != null) {
            for (EFTPaymentItemEditor itemEditor : this.getEFTItemEditors()) {
                if (itemEditor.canDelete()) continue;
                this.eftTill = till;
            }
        }
    }

    public Party getCustomer() {
        return (Party)this.getParticipant("customer");
    }

    public boolean isPosted() {
        return this.getStatus().equals("POSTED");
    }

    public void makeSaveable() {
        this.status.makeSaveable();
    }

    public void makeSaveableAndPostOnCompletion() {
        this.status.makeSaveableAndPostOnCompletion();
    }

    public void setInvoiceAmount(BigDecimal amount) {
        this.invoiceAmount.setValue((Object)amount);
    }

    public BigDecimal getInvoiceAmount() {
        return this.invoiceAmount.getBigDecimal(BigDecimal.ZERO);
    }

    public void setExpectedAmount(BigDecimal amount) {
        this.expectedAmount = amount;
    }

    public BigDecimal getExpectedAmount() {
        return this.expectedAmount;
    }

    public void setTill(Entity till) {
        this.setParticipant("till", till);
    }

    public Entity getTill() {
        return this.getParticipant("till");
    }

    public boolean requiresTransaction() {
        return this.getRequiresTransactionEditor() != null;
    }

    public TransactionPaymentItemEditor getRequiresTransactionEditor() {
        TransactionPaymentItemEditor editor = null;
        if (!this.status.isReadOnly()) {
            editor = this.getTransactionPaymentItemEditors().stream().filter(TransactionPaymentItemEditor::requiresTransaction).findFirst().orElse(null);
        }
        return editor;
    }

    public void processTransactions(Runnable listener) {
        if (!this.status.isReadOnly() && this.isValid()) {
            List<TransactionPaymentItemEditor> editors = this.getTransactionPaymentItemEditors();
            this.processTransactions(editors.iterator(), listener);
        }
    }

    public boolean postOnCompletion() {
        return this.status.postOnCompletion();
    }

    public boolean canChangeStatus() {
        return !this.status.isReadOnly();
    }

    public boolean canDelete() {
        boolean result = false;
        if (!this.getObject().isNew() && this.canChangeStatus()) {
            result = true;
            for (PaymentItemEditor editor : this.getPaymentItemEditors()) {
                if (editor.canDelete()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isEmptyOrOnlyHasTransactionItems() {
        List items = this.getItems().getCurrentActs();
        boolean result = items.isEmpty() ? true : items.stream().allMatch(act -> act.isA(new String[]{"act.customerAccountPaymentEFT", "act.customerAccountRefundEFT", "act.customerAccountPaymentPP", "act.customerAccountRefundPP"}));
        return result;
    }

    public void setAddDefaultItem(boolean addDefaultItem) {
        this.addDefaultItem = addDefaultItem;
    }

    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        PaymentItemRelationshipCollectionEditor editor = new PaymentItemRelationshipCollectionEditor(items, act, this.getLayoutContext());
        editor.setParent(this);
        return editor;
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new CustomerPaymentLayoutStrategy((IMObjectCollectionEditor)this.getItems(), this.getPaymentStatus());
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.initItems();
        ParticipationEditor till = this.getParticipationEditor("till", true);
        if (till != null) {
            till.addModifiableListener(modifiable -> this.onTillChanged());
        }
    }

    protected PaymentStatus getPaymentStatus() {
        return this.status;
    }

    protected boolean doValidation(Validator validator) {
        boolean valid;
        boolean requiresTransaction = this.requiresTransaction();
        if (requiresTransaction && this.status.isPosted()) {
            this.status.makeSaveableAndPostOnCompletion();
        }
        boolean bl = valid = super.doValidation(validator) && this.validateExpectedAmount(validator) && this.validateTill(validator) && this.validateReversal(validator);
        if (valid && requiresTransaction && "POSTED".equals(this.getStatus())) {
            validator.add((Modifiable)this, "Cannot finalise payment until EFT transactions are complete");
        }
        return validator.isValid();
    }

    protected void checkDeletePreconditions() {
        super.checkDeletePreconditions();
        for (PaymentItemEditor editor : this.getPaymentItemEditors()) {
            if (editor.canDelete() || editor instanceof TransactionPaymentItemEditor && ((TransactionPaymentItemEditor)editor).canCancelTransaction()) continue;
            throw new IllegalStateException("Cannot delete payment item: " + editor.getDisplayName());
        }
    }

    protected void prepareDelete() {
        super.prepareDelete();
        for (PaymentItemEditor editor : this.getPaymentItemEditors()) {
            TransactionPaymentItemEditor transactionEditor;
            Deletable deletable;
            if (!(editor instanceof TransactionPaymentItemEditor) || (deletable = (transactionEditor = (TransactionPaymentItemEditor)editor).getDeletable()).canDelete()) continue;
            if (transactionEditor.canCancelTransaction()) {
                transactionEditor.cancelTransaction();
                Deletable postCancel = transactionEditor.getDeletable();
                if (postCancel.canDelete()) continue;
                throw new PaymentException(postCancel.getReason());
            }
            throw new PaymentException(deletable.getReason());
        }
    }

    protected void doDelete() {
        List<PaymentItemEditor> editors = this.getPaymentItemEditors();
        for (PaymentItemEditor editor : editors) {
            if (editor.canDelete()) continue;
            throw new IllegalStateException("Cannot delete payment item: " + editor.getDisplayName());
        }
        super.doDelete();
    }

    protected List<EFTPaymentItemEditor> getEFTItemEditors() {
        return this.getTransactionPaymentItemEditors().stream().filter(editor -> editor instanceof EFTPaymentItemEditor).map(editor -> (EFTPaymentItemEditor)((Object)editor)).collect(Collectors.toList());
    }

    protected List<TransactionPaymentItemEditor> getTransactionPaymentItemEditors() {
        return this.getPaymentItemEditors().stream().filter(editor -> editor instanceof TransactionPaymentItemEditor).map(editor -> (TransactionPaymentItemEditor)((Object)editor)).collect(Collectors.toList());
    }

    protected List<PaymentItemEditor> getPaymentItemEditors() {
        ActRelationshipCollectionEditor items = this.getItems();
        return items.getCurrentActs().stream().map(arg_0 -> ((ActRelationshipCollectionEditor)items).getEditor(arg_0)).filter(editor -> editor instanceof PaymentItemEditor).map(editor -> (PaymentItemEditor)editor).collect(Collectors.toList());
    }

    protected void onCreated(FinancialAct act) {
        Party customer = (Party)this.getParticipant("customer");
        if (customer != null) {
            BigDecimal runningTotal = this.getRunningTotal();
            if (this.expectedAmount == null) {
                boolean payment = act.isA("act.customerAccountPayment*");
                BigDecimal balance = this.rules.getBalance(customer, runningTotal, payment);
                act.setTotal((BigDecimal)new Money(balance));
            } else {
                BigDecimal balance = this.expectedAmount.subtract(runningTotal);
                if (balance.signum() >= 0) {
                    act.setTotal((BigDecimal)new Money(balance));
                }
            }
            this.getItems().setModified((Act)act, true);
        }
    }

    protected Property getInvoiceAmountProperty() {
        return this.invoiceAmount;
    }

    protected SimpleProperty createProperty(String name, String key) {
        SimpleProperty property = new SimpleProperty(name, BigDecimal.class);
        property.setDisplayName(Messages.get((String)key));
        property.setReadOnly(true);
        return property;
    }

    private boolean validateExpectedAmount(Validator validator) {
        if (this.expectedAmount != null) {
            this.validateAmount(this.expectedAmount, validator);
        }
        return validator.isValid();
    }

    private void validateAmount(BigDecimal expected, Validator validator) {
        Property property = this.getProperty("amount");
        BigDecimal amount = property.getBigDecimal(BigDecimal.ZERO);
        if (amount.compareTo(expected) != 0) {
            validator.add((Modifiable)property, Messages.format((String)"customer.payment.amountMismatch", (Object[])new Object[]{NumberFormatter.formatCurrency((Number)expected)}));
        }
    }

    private boolean validateTill(Validator validator) {
        if (this.eftTill != null && !this.eftTill.equals(this.getTill())) {
            validator.add((Modifiable)this, Messages.get((String)"customer.payment.eft.cannotchangetill"));
        }
        return validator.isValid();
    }

    private boolean validateReversal(Validator validator) {
        if (this.reversalAmount != null) {
            this.validateAmount(this.reversalAmount, validator);
        }
        return validator.isValid();
    }

    private void processTransactions(Iterator<TransactionPaymentItemEditor> iterator, Runnable listener) {
        if (iterator.hasNext()) {
            TransactionPaymentItemEditor editor = iterator.next();
            editor.performTransaction(() -> this.processTransactions(iterator, listener));
        } else {
            listener.run();
        }
    }

    private void initItems() {
        ActRelationshipCollectionEditor items;
        CollectionProperty property;
        if (this.addDefaultItem && (property = (items = this.getItems()).getCollection()).getValues().isEmpty()) {
            this.addItem();
        }
    }

    private void onTillChanged() {
        Entity till = this.getTill();
        if (this.eftTill == null || !this.eftTill.equals(till)) {
            for (EFTPaymentItemEditor itemEditor : this.getEFTItemEditors()) {
                itemEditor.setTill(till);
            }
        }
    }

    private BigDecimal getRunningTotal() {
        FinancialAct act = this.getObject();
        BigDecimal total = act.getTotal();
        BigDecimal committed = ActHelper.sum((Act)act, (String)"amount");
        return total.subtract(committed);
    }
}

