/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;

public class PendingOrderQuery
extends AbstractQuery<Act> {
    public static final String[] SHORT_NAMES = new String[]{"act.customerOrder*", "act.customerReturn*"};
    private final Party customer;
    private final Party patient;
    private final OrderRules rules;
    private final FocusGroup group = new FocusGroup("PendingOrderQuery");
    private final List<Act> exclude;

    public PendingOrderQuery(Party customer) {
        this(customer, null, Collections.emptyList());
    }

    public PendingOrderQuery(Party customer, Party patient, List<Act> exclude) {
        super(SHORT_NAMES, Act.class);
        this.customer = customer;
        this.patient = patient;
        this.exclude = exclude;
        this.rules = (OrderRules)ServiceHelper.getBean(OrderRules.class);
    }

    public ResultSet<Act> query(SortConstraint[] sort) {
        List<Act> acts = this.getOrders();
        return new ListResultSet(acts, this.getMaxResults());
    }

    public boolean selects(Reference reference) {
        for (Act act : this.getOrders()) {
            if (!act.getObjectReference().equals((Object)reference)) continue;
            return true;
        }
        return false;
    }

    public BaseArchetypeConstraint.State getActive() {
        return BaseArchetypeConstraint.State.ACTIVE;
    }

    public Component getComponent() {
        return LabelFactory.create((String)"customer.order.invoice.message");
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    private List<Act> getOrders() {
        List acts = this.rules.getOrders(this.customer, this.patient);
        acts.removeAll(this.exclude);
        return acts;
    }
}

