/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.AbstractInvoicer;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.order.OrderCharger;

public abstract class OrderInvoicer
extends AbstractInvoicer {
    private final FinancialAct act;
    private final User clinician;
    private final ArchetypeService service;
    private final Reference customer;
    private final List<Item> items;
    private final FinancialAct invoice;
    private final Map<Reference, FinancialAct> invoices = new HashMap<Reference, FinancialAct>();
    private final PropertySet properties;

    public OrderInvoicer(FinancialAct act, User clinician, OrderRules rules, IArchetypeService service) {
        if (service instanceof IArchetypeRuleService) {
            throw new IllegalArgumentException("Argument 'service' must not implement IArchetypeRuleService");
        }
        this.act = act;
        this.clinician = clinician;
        this.service = service;
        IMObjectBean bean = service.getBean((IMObject)act);
        this.customer = bean.getTargetRef("customer");
        this.items = new ArrayList<Item>();
        for (FinancialAct item : bean.getTargets("items", FinancialAct.class)) {
            Reference invoiceItemRef = rules.getInvoiceItemRef((Act)item);
            FinancialAct invoiceItem = invoiceItemRef != null ? (FinancialAct)service.get(invoiceItemRef, FinancialAct.class) : null;
            FinancialAct invoice = null;
            if (invoiceItem != null) {
                invoice = this.getInvoice(invoiceItem, this.invoices);
            }
            boolean ordered = invoiceItemRef != null;
            this.items.add(this.createItem(item, ordered, invoiceItem, invoice));
        }
        this.invoice = this.invoices.size() == 1 ? this.invoices.values().iterator().next() : null;
        this.properties = new PropertySetBuilder((IMObject)act).build();
    }

    public boolean isOrder() {
        return !this.act.isCredit();
    }

    public boolean isOrderReturn() {
        return !this.isOrder();
    }

    public Reference getCustomer() {
        return this.customer;
    }

    public FinancialAct getInvoice() {
        return this.invoice;
    }

    public boolean isValid() {
        return this.validate((Validator)new DefaultValidator());
    }

    public boolean validate(Validator validator) {
        boolean valid;
        block5: {
            Item item;
            valid = false;
            Property property = this.properties.get("items");
            if (this.items.isEmpty()) {
                String message = Messages.format((String)"property.error.minSize", (Object[])new Object[]{property.getDisplayName(), 1});
                validator.add((Modifiable)property, new ValidatorError(property, message));
            } else if (this.invoices.size() > 1) {
                validator.add((Modifiable)property, new ValidatorError(Messages.get((String)"customer.order.invoice.unsupported")));
            } else {
                valid = OrderInvoicer.validateRequired(validator, this.properties, "customer", this.customer);
            }
            if (!valid) break block5;
            Iterator<Item> iterator = this.items.iterator();
            while (iterator.hasNext() && (valid = (item = iterator.next()).validate(validator))) {
            }
        }
        return valid;
    }

    public boolean canCharge(Party patient) {
        boolean result;
        block1: {
            Item item;
            result = this.isValid();
            if (!result) break block1;
            Reference ref = patient.getObjectReference();
            Iterator<Item> iterator = this.items.iterator();
            while (iterator.hasNext() && (result = (item = iterator.next()).hasPatient(ref))) {
            }
        }
        return result;
    }

    public boolean canCharge(CustomerChargeActEditor editor) {
        return this.getChargeStatus(editor).canCharge();
    }

    public Status getChargeStatus(CustomerChargeActEditor editor) {
        FinancialAct charge = editor.getObject();
        Status result = !"POSTED".equals(editor.getStatus()) ? (this.invoice != null && this.invoice.getId() == charge.getId() ? Status.valid() : (this.invoice == null ? Status.valid() : (this.invoice.getId() != editor.getObject().getId() ? Status.invalid(Messages.format((String)"customer.order.differentInvoice", (Object[])new Object[]{this.act.getId(), DescriptorHelper.getDisplayName((IMObject)this.act, (ArchetypeService)this.service), this.invoice.getId()})) : Status.valid()))) : Status.invalid(Messages.format((String)"customer.order.chargefinalised", (Object[])new Object[]{editor.getDisplayName()}));
        return result;
    }

    public CustomerChargeActEditDialog charge(FinancialAct charge, OrderCharger charger, LayoutContext context) {
        if (charge != null && "POSTED".equals(charge.getStatus())) {
            throw new IllegalStateException("Cannot charge orders/returns to POSTED " + charge.getArchetype());
        }
        if (!this.isValid()) {
            throw new IllegalStateException("The order is incomplete and cannot be invoiced");
        }
        if (charge == null) {
            if (this.canInvoice() && this.isOrder()) {
                charge = this.createInvoice(this.customer);
            } else if (this.canCredit()) {
                charge = this.createCharge("act.customerAccountChargesCredit", this.customer);
            } else {
                throw new IllegalStateException("Can neither invoice nor credit the " + this.act.getArchetype());
            }
        }
        CustomerChargeActEditor editor = this.createChargeEditor(charge, context);
        DefaultCustomerChargeActEditDialog dialog = new DefaultCustomerChargeActEditDialog(editor, charger, context.getContext(), false);
        dialog.show();
        this.doCharge(editor);
        return dialog;
    }

    public boolean requiresEdit() {
        for (Item item : this.items) {
            if (!item.requiresEdit()) continue;
            return true;
        }
        return false;
    }

    public void charge() {
        ArrayList<FinancialAct> updated = new ArrayList<FinancialAct>();
        for (Item item : this.items) {
            if (!item.updateReceivedQuantity()) {
                throw new IllegalStateException("Failed to update received quantity");
            }
            updated.add(item.getInvoiceItem());
        }
        this.act.setStatus("POSTED");
        updated.add(this.act);
        this.service.save(updated);
    }

    public void charge(CustomerChargeActEditor editor) {
        if (!this.isValid()) {
            throw new IllegalStateException("The order is incomplete and cannot be invoiced");
        }
        if (!this.canCharge(editor)) {
            throw new IllegalStateException("Cannot charge " + this.act.getArchetype() + " to editor");
        }
        this.doCharge(editor);
    }

    public boolean canInvoice() {
        boolean result = true;
        for (Item item : this.items) {
            if (item.canInvoice()) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean canCredit() {
        boolean result = true;
        for (Item item : this.items) {
            if (item.canCredit()) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean notFromInvoice() {
        boolean result = true;
        for (Item item : this.items) {
            if (!item.isOrdered()) continue;
            result = false;
            break;
        }
        return result;
    }

    public CustomerChargeActEditDialog returnItems(FinancialAct invoice, OrderCharger charger, LayoutContext context) {
        DefaultCustomerChargeActEditDialog result = null;
        CustomerChargeActEditor editor = this.createChargeEditor(invoice, context);
        DefaultCustomerChargeActEditDialog dialog = new DefaultCustomerChargeActEditDialog(editor, charger, context.getContext(), false);
        if (this.applyOrderReturnToInvoice(editor)) {
            dialog.show();
            result = dialog;
        }
        return result;
    }

    protected Item createItem(FinancialAct item, boolean ordered, FinancialAct invoiceItem, FinancialAct invoice) {
        return new Item(item, ordered, invoiceItem, invoice);
    }

    protected static boolean validateRequired(Validator validator, PropertySet properties, String name, Object value) {
        boolean valid = false;
        if (value != null) {
            valid = true;
        } else {
            Property property = properties.get(name);
            validator.add((Modifiable)property, new ValidatorError(property, Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()})));
        }
        return valid;
    }

    private boolean doCharge(CustomerChargeActEditor editor) {
        boolean result;
        ChargeItemRelationshipCollectionEditor items = editor.getItems();
        if (this.isOrderReturn() && this.notFromInvoice() && editor.getObject().isA("act.customerAccountChargesInvoice")) {
            result = this.applyOrderReturnToInvoice(editor);
        } else {
            for (Item item : this.items) {
                FinancialAct current = item.getCurrentInvoiceItem(editor);
                CustomerChargeActItemEditor itemEditor = current != null ? this.getItemEditor((Act)current, editor) : this.getItemEditor(editor);
                item.charge(editor, itemEditor);
            }
            this.act.setStatus("POSTED");
            items.refresh();
            result = true;
        }
        return result;
    }

    private void applyReturn(CustomerChargeActEditor editor) {
        ChargeItemRelationshipCollectionEditor chargeItems = editor.getItems();
        for (Item item : this.items) {
            FinancialAct invoiceItem = null;
            FinancialAct fallback = null;
            BigDecimal fallbackQuantity = null;
            List acts = chargeItems.getCurrentActs();
            BigDecimal quantity = item.getQuantity();
            for (Act act : acts) {
                IMObjectBean bean = this.service.getBean((IMObject)act);
                if (this.isOrdered(act) || !item.samePatientAndProduct(bean)) continue;
                BigDecimal chargeQuantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
                if (MathRules.equals((BigDecimal)quantity, (BigDecimal)chargeQuantity)) {
                    invoiceItem = (FinancialAct)act;
                    break;
                }
                if (fallback != null && fallbackQuantity.compareTo(chargeQuantity) >= 0) continue;
                fallback = (FinancialAct)act;
                fallbackQuantity = chargeQuantity;
            }
            if (invoiceItem == null) {
                invoiceItem = fallback;
            }
            CustomerChargeActItemEditor itemEditor = null;
            if (invoiceItem != null) {
                itemEditor = chargeItems.getEditor((IMObject)invoiceItem);
                BigDecimal newInvoiceQty = itemEditor.getQuantity().subtract(item.getQuantity());
                if (newInvoiceQty.compareTo(BigDecimal.ZERO) < 0 && !invoiceItem.isNew()) {
                    if (MathRules.isZero((BigDecimal)itemEditor.getMinimumQuantity())) {
                        editor.removeItem((Act)itemEditor.getObject());
                    } else {
                        this.updateQuantity(itemEditor, item.getStartTime(), BigDecimal.ZERO);
                    }
                    FinancialAct newInvoiceItem = this.addInvoiceItem(chargeItems);
                    this.populate((IMObject)newInvoiceItem, item, newInvoiceQty, chargeItems.getPricingContext(), editor.getDepartment(), editor.getStockLocation());
                    chargeItems.getEditor((IMObject)newInvoiceItem);
                } else {
                    this.updateQuantity(itemEditor, item.getStartTime(), newInvoiceQty);
                }
                if (MathRules.isZero((BigDecimal)newInvoiceQty) && MathRules.isZero((BigDecimal)itemEditor.getMinimumQuantity())) {
                    editor.removeItem((Act)itemEditor.getObject());
                    continue;
                }
                this.updateQuantity(itemEditor, item.getStartTime(), newInvoiceQty);
                continue;
            }
            FinancialAct newInvoiceItem = this.addInvoiceItem(chargeItems);
            this.populate((IMObject)newInvoiceItem, item, item.quantity.negate(), chargeItems.getPricingContext(), editor.getDepartment(), editor.getStockLocation());
            chargeItems.getEditor((IMObject)newInvoiceItem);
        }
    }

    private void updateQuantity(CustomerChargeActItemEditor itemEditor, Date startTime, BigDecimal quantity) {
        itemEditor.setStartTime(startTime);
        itemEditor.setQuantity(quantity);
    }

    private FinancialAct addInvoiceItem(ChargeItemRelationshipCollectionEditor chargeItems) {
        FinancialAct newInvoiceItem = (FinancialAct)chargeItems.create();
        if (newInvoiceItem == null || !chargeItems.add((IMObject)newInvoiceItem)) {
            throw new IllegalStateException("Failed to create invoice item");
        }
        return newInvoiceItem;
    }

    private void populate(IMObject act, Item item, BigDecimal quantity, PricingContext pricingContext, Entity department, Party stockLocation) {
        BigDecimal price;
        IMObjectBean bean = this.service.getBean(act);
        bean.setValue("startTime", (Object)item.startTime);
        bean.setTarget("patient", item.patient);
        bean.setTarget("product", item.product);
        bean.setValue("quantity", (Object)quantity);
        Reference clinicianRef = item.clinician;
        if (clinicianRef == null && this.clinician != null) {
            clinicianRef = this.clinician.getObjectReference();
        }
        bean.setTarget("clinician", clinicianRef);
        bean.setTarget("department", (IMObject)department);
        bean.setTarget("stockLocation", (IMObject)stockLocation);
        Product product = (Product)this.service.get(item.product, Product.class);
        if (product == null) {
            throw new IllegalStateException("Failed to retrieve product: " + item.product);
        }
        BigDecimal serviceRatio = pricingContext.getServiceRatio(product, department, item.startTime);
        bean.setValue("serviceRatio", (Object)serviceRatio);
        ProductPrice fixedPrice = pricingContext.getFixedPrice(product, item.startTime);
        ProductPrice unitPrice = pricingContext.getUnitPrice(product, item.startTime);
        if (fixedPrice != null) {
            price = pricingContext.getPrice(product, fixedPrice, serviceRatio);
            bean.setValue("fixedPrice", (Object)price);
        }
        if (unitPrice != null) {
            price = pricingContext.getPrice(product, unitPrice, serviceRatio);
            bean.setValue("unitPrice", (Object)price);
        }
    }

    private boolean isOrdered(Act item) {
        return item.getStatus() != null;
    }

    private boolean applyOrderReturnToInvoice(CustomerChargeActEditor editor) {
        boolean result = false;
        if (this.isOrderReturn()) {
            this.applyReturn(editor);
            this.act.setStatus("POSTED");
            editor.getItems().refresh();
            result = true;
        }
        return result;
    }

    private FinancialAct getInvoice(FinancialAct invoiceItem, Map<Reference, FinancialAct> invoices) {
        FinancialAct invoice = null;
        IMObjectBean bean = this.service.getBean((IMObject)invoiceItem);
        Reference ref = bean.getSourceRef("invoice");
        if (ref != null && (invoice = invoices.get(ref)) == null && (invoice = (FinancialAct)this.service.get(ref, FinancialAct.class)) != null) {
            invoices.put(ref, invoice);
        }
        return invoice;
    }

    protected class Item {
        private final boolean ordered;
        private final Date startTime;
        private final Reference patient;
        private final BigDecimal quantity;
        private final Reference product;
        private final Reference clinician;
        private final FinancialAct invoiceItem;
        private final BigDecimal invoiceQty;
        private final BigDecimal receivedQty;
        private final BigDecimal returnedQty;
        private final boolean isOrder;
        private final boolean posted;
        private final PropertySet properties;

        public Item(FinancialAct orderItem, boolean ordered, FinancialAct invoiceItem, FinancialAct invoice) {
            IMObjectBean bean = OrderInvoicer.this.service.getBean((IMObject)orderItem);
            this.ordered = ordered;
            this.startTime = orderItem.getActivityStartTime();
            this.patient = bean.getTargetRef("patient");
            this.product = bean.getTargetRef("product");
            this.clinician = bean.getTargetRef("clinician");
            this.quantity = bean.getBigDecimal("quantity", BigDecimal.ZERO);
            this.invoiceItem = invoiceItem;
            boolean bl = this.isOrder = !orderItem.isCredit();
            if (invoiceItem != null) {
                this.invoiceQty = invoiceItem.getQuantity();
                IMObjectBean invoiceBean = OrderInvoicer.this.service.getBean((IMObject)invoiceItem);
                this.receivedQty = invoiceBean.getBigDecimal("receivedQuantity", BigDecimal.ZERO);
                this.returnedQty = invoiceBean.getBigDecimal("returnedQuantity", BigDecimal.ZERO);
            } else {
                this.invoiceQty = BigDecimal.ZERO;
                this.receivedQty = BigDecimal.ZERO;
                this.returnedQty = BigDecimal.ZERO;
            }
            this.posted = invoice != null && "POSTED".equals(invoice.getStatus());
            this.properties = new PropertySetBuilder((IMObject)orderItem).build();
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean isOrder() {
            return this.isOrder;
        }

        public boolean isPosted() {
            return this.posted;
        }

        public FinancialAct getInvoiceItem() {
            return this.invoiceItem;
        }

        public Reference getProduct() {
            return this.product;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public boolean isValid() {
            return this.validate((Validator)new DefaultValidator());
        }

        public boolean validate(Validator validator) {
            return this.validateRequired(validator, "patient", this.patient) && this.validateRequired(validator, "quantity", this.quantity) && this.validateRequired(validator, "product", this.product) && this.validateProduct(validator);
        }

        public boolean canInvoice() {
            BigDecimal newQuantity;
            boolean result = this.isOrder ? this.invoiceItem == null || !this.posted || this.quantity.compareTo(this.invoiceQty) >= 0 : (this.invoiceItem == null ? !this.ordered : (!this.posted ? (newQuantity = this.receivedQty.subtract(this.returnedQty).subtract(this.quantity)).compareTo(BigDecimal.ZERO) >= 0 : false));
            return result;
        }

        public boolean requiresEdit() {
            boolean result = true;
            if (this.canInvoice() && this.ordered && this.receivedQty.subtract(this.returnedQty).add(this.quantity).compareTo(this.invoiceQty) <= 0) {
                result = !this.sameDetails();
            }
            return result;
        }

        public boolean canCredit() {
            return !this.isOrder || this.invoiceItem != null && this.invoiceQty.compareTo(this.quantity) > 0;
        }

        public boolean updateReceivedQuantity() {
            boolean result = false;
            if (this.isOrder && this.invoiceItem != null && this.posted) {
                IMObjectBean bean = OrderInvoicer.this.service.getBean((IMObject)this.invoiceItem);
                BigDecimal received = this.receivedQty.add(this.quantity);
                if (received.subtract(this.returnedQty).compareTo(this.invoiceQty) <= 0) {
                    bean.setValue("receivedQuantity", (Object)received);
                    result = true;
                }
            }
            return result;
        }

        public void charge(CustomerChargeActEditor editor, CustomerChargeActItemEditor itemEditor) {
            FinancialAct object = itemEditor.getObject();
            itemEditor.setStartTime(this.startTime);
            itemEditor.setPatientRef(this.patient);
            itemEditor.setProductRef(this.product);
            if (object.isA("act.customerAccountInvoiceItem")) {
                BigDecimal newInvoiceQty;
                BigDecimal received = itemEditor.getReceivedQuantity();
                BigDecimal returned = itemEditor.getReturnedQuantity();
                if (this.isOrder) {
                    received = received.add(this.quantity);
                    newInvoiceQty = this.invoiceItem != null && this.posted ? received.subtract(this.invoiceQty).subtract(returned).max(BigDecimal.ZERO) : received;
                    itemEditor.setReceivedQuantity(received);
                } else {
                    returned = returned.add(this.quantity);
                    itemEditor.setReturnedQuantity(returned);
                    newInvoiceQty = received.subtract(returned).max(BigDecimal.ZERO);
                }
                itemEditor.setQuantity(newInvoiceQty);
            } else {
                itemEditor.setQuantity(this.quantity);
            }
            if (this.clinician != null) {
                itemEditor.setClinicianRef(this.clinician);
            }
            editor.setOrdered((Act)itemEditor.getObject());
        }

        public boolean hasPatient(Reference patient) {
            return Objects.equals(patient, this.patient);
        }

        public Reference getInvoice() {
            Reference result = null;
            if (this.invoiceItem != null) {
                IMObjectBean bean = OrderInvoicer.this.service.getBean((IMObject)this.invoiceItem);
                result = bean.getSourceRef("invoice");
            }
            return result;
        }

        public FinancialAct getCurrentInvoiceItem(CustomerChargeActEditor editor) {
            List acts;
            int index;
            FinancialAct result = null;
            if (this.invoiceItem != null && (index = (acts = editor.getItems().getCurrentActs()).indexOf(this.invoiceItem)) != -1) {
                result = (FinancialAct)acts.get(index);
            }
            return result;
        }

        public boolean sameDetails() {
            if (this.invoiceItem != null) {
                IMObjectBean bean = OrderInvoicer.this.service.getBean((IMObject)this.invoiceItem);
                return this.samePatientAndProduct(bean);
            }
            return false;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        protected boolean validateRequired(Validator validator, String name, Object value) {
            return OrderInvoicer.validateRequired(validator, this.properties, name, value);
        }

        protected boolean validateProduct(Validator validator) {
            boolean valid = false;
            if (this.product.isA(this.getProductArchetypes())) {
                valid = true;
            } else {
                Property property = this.properties.get("product");
                String msg = Messages.format((String)"imobject.invalidreference", (Object[])new Object[]{property.getDisplayName()});
                validator.add((Modifiable)property, new ValidatorError(property, msg));
            }
            return valid;
        }

        protected String[] getProductArchetypes() {
            return new String[]{"product.medication", "product.merchandise", "product.service"};
        }

        private boolean samePatientAndProduct(IMObjectBean bean) {
            return Objects.equals(bean.getTargetRef("patient"), this.patient) && Objects.equals(bean.getTargetRef("product"), this.product);
        }
    }

    public static class Status {
        private final String reason;

        private Status(String reason) {
            this.reason = reason;
        }

        public boolean canCharge() {
            return this.reason == null;
        }

        public String getReason() {
            return this.reason;
        }

        public static Status valid() {
            return new Status(null);
        }

        public static Status invalid(String reason) {
            if (reason == null) {
                throw new IllegalArgumentException("Argument 'reason' is null");
            }
            return new Status(reason);
        }
    }
}

