/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.customer.CustomerBrowser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.BasicCRUDWorkspace;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.CustomerSummary;
import org.openvpms.web.workspace.customer.info.InformationCRUDWindow;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;

public class InformationWorkspace
extends BasicCRUDWorkspace<Party> {
    private final Preferences preferences;
    private final MandatoryAlerts alerts;

    public InformationWorkspace(Context context, Preferences preferences) {
        super("customer.information", context);
        this.setArchetypes(Party.class, new String[]{"party.customer*"});
        this.setMailContext((MailContext)new CustomerMailContext(context, true, this.getHelpContext()));
        this.preferences = preferences;
        this.alerts = new MandatoryAlerts(context, this.getHelpContext());
    }

    public void setObject(Party object) {
        super.setObject((IMObject)object);
        ContextHelper.setCustomer((Context)this.getContext(), (Party)object);
        this.firePropertyChange("summary", null, null);
    }

    public void show() {
        super.show();
        this.alerts.show((Party)this.getObject());
    }

    public Component getSummary() {
        CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
        CustomerSummary summarizer = factory.createCustomerSummary(this.getContext(), this.getHelpContext(), this.preferences);
        return summarizer.getSummary((Party)this.getObject());
    }

    protected void onSelected(Party object) {
        super.onSelected((IMObject)object);
        this.alerts.show((Party)this.getObject());
    }

    protected Party getLatest() {
        return (Party)this.getLatest((IMObject)this.getContext().getCustomer());
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        Party latest = this.getLatest();
        if (latest != this.getObject()) {
            this.setObject(latest);
        }
    }

    protected CRUDWindow<Party> createCRUDWindow() {
        return new InformationCRUDWindow((Archetypes<Party>)this.getArchetypes(), this.getContext(), this.getHelpContext());
    }

    protected void onSelectClosed(BrowserDialog<Party> dialog) {
        if (dialog.createNew()) {
            this.getCRUDWindow().create();
        } else {
            Party customer = (Party)dialog.getSelected();
            if (customer != null) {
                CustomerBrowser browser;
                Party patient;
                this.onSelected(customer);
                if (dialog.getBrowser() instanceof CustomerBrowser && (patient = (browser = (CustomerBrowser)dialog.getBrowser()).getPatient()) != null) {
                    ContextHelper.setPatient((Context)this.getContext(), (Party)patient);
                }
            }
        }
    }
}

