/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.bound.BoundProperty;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.Quantity;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.FixedPriceEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.PriceActItemEditor;
import org.openvpms.web.workspace.customer.charge.ChargeEditContext;

public class EstimateItemEditor
extends PriceActItemEditor {
    private final Quantity lowQuantity;
    private final Quantity highQuantity;
    private final ModifiableListener lowDiscountListener;
    private final ModifiableListener highDiscountListener;
    private final ModifiableListener totalListener;
    private final Label lowQtySellingUnits = LabelFactory.create();
    private final Label highQtySellingUnits = LabelFactory.create();
    private static final String FIXED_PRICE = "fixedPrice";
    private static final String LOW_UNIT_PRICE = "lowUnitPrice";
    private static final String HIGH_UNIT_PRICE = "highUnitPrice";
    private static final String LOW_QTY = "lowQty";
    private static final String HIGH_QTY = "highQty";
    private static final String LOW_DISCOUNT = "lowDiscount";
    private static final String HIGH_DISCOUNT = "highDiscount";
    private static final String LOW_TOTAL = "lowTotal";
    private static final String HIGH_TOTAL = "highTotal";
    private static final ArchetypeNodes TEMPLATE_NODES = new ArchetypeNodes().exclude(new String[]{"lowQty", "highQty", "fixedPrice", "lowUnitPrice", "highUnitPrice", "lowDiscount", "highDiscount", "print", "lowTotal", "highTotal"});

    public EstimateItemEditor(Act act, Act parent, ChargeEditContext context, LayoutContext layoutContext) {
        super(act, parent, context, layoutContext);
        if (!TypeHelper.isA((IMObject)act, (String)"act.customerEstimationItem")) {
            throw new IllegalArgumentException("Invalid act type:" + act.getArchetype());
        }
        if (act.isNew()) {
            act.setActivityStartTime(new Date());
        }
        this.lowQuantity = new Quantity(this.getProperty(LOW_QTY), (IMObject)act, this.getLayoutContext());
        if (context.overrideMinimumQuantities()) {
            this.lowQuantity.getProperty().addModifiableListener(modifiable -> this.onLowQuantityChanged());
        }
        this.highQuantity = new Quantity(this.getProperty(HIGH_QTY), (IMObject)act, this.getLayoutContext());
        Product product = this.getProduct();
        boolean showPrint = this.updatePrint(product);
        ArchetypeNodes nodes = this.getFilterForProduct(product, showPrint);
        this.setArchetypeNodes(nodes);
        ModifiableListener listener = modifiable -> this.updateDiscount();
        ModifiableListener lowListener = modifiable -> this.recalculateLow();
        ModifiableListener highListener = modifiable -> this.recalculateHigh();
        this.getProperty(FIXED_PRICE).addModifiableListener(listener);
        this.getProperty(LOW_UNIT_PRICE).addModifiableListener(lowListener);
        this.lowQuantity.getProperty().addModifiableListener(lowListener);
        this.getProperty(HIGH_UNIT_PRICE).addModifiableListener(highListener);
        this.highQuantity.getProperty().addModifiableListener(highListener);
        this.lowDiscountListener = modifiable -> this.calculateLowTotal();
        this.getProperty(LOW_DISCOUNT).addModifiableListener(this.lowDiscountListener);
        this.highDiscountListener = modifiable -> this.calculateHighTotal();
        this.getProperty(HIGH_DISCOUNT).addModifiableListener(this.highDiscountListener);
        this.totalListener = modifiable -> this.onTotalChanged();
        this.getProperty(LOW_TOTAL).addModifiableListener(this.totalListener);
        this.getProperty(HIGH_TOTAL).addModifiableListener(this.totalListener);
    }

    public void setQuantity(BigDecimal quantity) {
        this.setLowQuantity(quantity);
        this.setHighQuantity(quantity);
    }

    public BigDecimal getQuantity() {
        return this.getHighQuantity();
    }

    public BigDecimal getLowQuantity() {
        return this.lowQuantity.getValue(BigDecimal.ZERO);
    }

    public void setLowQuantity(BigDecimal quantity) {
        this.lowQuantity.setValue(quantity);
    }

    public BigDecimal getHighQuantity() {
        return this.highQuantity.getValue(BigDecimal.ZERO);
    }

    public void setHighQuantity(BigDecimal quantity) {
        this.highQuantity.setValue(quantity);
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.getProperty(LOW_UNIT_PRICE).setValue((Object)unitPrice);
        this.getProperty(HIGH_UNIT_PRICE).setValue((Object)unitPrice);
    }

    public BigDecimal getUnitPrice() {
        return this.getHighUnitPrice();
    }

    public BigDecimal getLowUnitPrice() {
        return this.getProperty(LOW_UNIT_PRICE).getBigDecimal(BigDecimal.ZERO);
    }

    public BigDecimal getHighUnitPrice() {
        return this.getProperty(HIGH_UNIT_PRICE).getBigDecimal(BigDecimal.ZERO);
    }

    public void setDiscount(BigDecimal discount) {
        this.setLowDiscount(discount);
        this.setHighDiscount(discount);
    }

    public void setLowDiscount(BigDecimal lowDiscount) {
        this.getProperty(LOW_DISCOUNT).setValue((Object)lowDiscount);
    }

    public BigDecimal getLowDiscount() {
        return this.getProperty(LOW_DISCOUNT).getBigDecimal(BigDecimal.ZERO);
    }

    public void setHighDiscount(BigDecimal highDiscount) {
        this.getProperty(HIGH_DISCOUNT).setValue((Object)highDiscount);
    }

    public BigDecimal getHighDiscount() {
        return this.getProperty(HIGH_DISCOUNT).getBigDecimal(BigDecimal.ZERO);
    }

    @Override
    public void setProduct(TemplateProduct product, Product template, int group) {
        this.setMinimumQuantity(null);
        this.setTemplate(template, group);
        if (product != null) {
            this.setQuantity(BigDecimal.ZERO);
            this.setProduct(product.getProduct());
            this.setMinimumQuantity(product.getLowQuantity());
            if (MathRules.isZero((BigDecimal)this.getHighQuantity())) {
                this.setLowQuantity(product.getLowQuantity());
                this.setHighQuantity(product.getHighQuantity());
            } else if (MathRules.isZero((BigDecimal)product.getLowQuantity())) {
                this.setLowQuantity(BigDecimal.ZERO);
            }
            if (product.getZeroPrice()) {
                this.setFixedPrice(BigDecimal.ZERO);
                this.setUnitPrice(BigDecimal.ZERO);
                this.setDiscount(BigDecimal.ZERO);
            }
            if (!product.getPrint()) {
                BigDecimal low = this.getLowTotal();
                BigDecimal high = this.getHighTotal();
                if (MathRules.isZero((BigDecimal)low) && MathRules.isZero((BigDecimal)high)) {
                    this.setPrint(false);
                }
            }
        } else {
            this.setProduct(null);
        }
    }

    public BigDecimal getLowTotal() {
        return this.getProperty(LOW_TOTAL).getBigDecimal(BigDecimal.ZERO);
    }

    public BigDecimal getHighTotal() {
        return this.getProperty(HIGH_TOTAL).getBigDecimal(BigDecimal.ZERO);
    }

    @Override
    protected boolean validateMinimumQuantity(Validator validator) {
        boolean result = true;
        BigDecimal minQuantity = this.getMinimumQuantity();
        if (!MathRules.isZero((BigDecimal)minQuantity) && this.getLowQuantity().compareTo(minQuantity) < 0) {
            Product product = this.getProduct();
            String name = product != null ? product.getName() : null;
            Property property = this.getProperty(LOW_QTY);
            String message = Messages.format((String)"customer.charge.minquantity", (Object[])new Object[]{name, minQuantity});
            validator.add((Modifiable)property, new ValidatorError(property, message));
            result = false;
        }
        return result;
    }

    @Override
    protected void productModified(Product product) {
        this.getProperty(LOW_TOTAL).removeModifiableListener(this.totalListener);
        this.getProperty(HIGH_TOTAL).removeModifiableListener(this.totalListener);
        super.productModified(product);
        Property lowDiscount = this.getProperty(LOW_DISCOUNT);
        Property highDiscount = this.getProperty(HIGH_DISCOUNT);
        lowDiscount.setValue((Object)BigDecimal.ZERO);
        highDiscount.setValue((Object)BigDecimal.ZERO);
        this.updatePrices(product);
        boolean showPrint = false;
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            this.updateSellingUnits(null);
        } else {
            BigDecimal dose;
            Party patient;
            boolean clearDefault = true;
            if (TypeHelper.isA((IMObject)product, (String)"product.medication") && (patient = this.getPatient()) != null && !MathRules.isZero((BigDecimal)(dose = this.getDose(product, patient)))) {
                this.lowQuantity.setValue(dose, true);
                this.highQuantity.setValue(dose, true);
                clearDefault = false;
            }
            if (clearDefault) {
                this.lowQuantity.clearDefault();
                this.highQuantity.clearDefault();
            }
            showPrint = this.updatePrint(product);
            this.updateSellingUnits(product);
        }
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null) {
            boolean readOnly = this.needsReadOnlyProduct();
            productEditor.setReadOnly(readOnly);
        }
        this.setPrint(true);
        this.updateLayout(product, showPrint);
        this.notifyProductListener(product);
        this.getProperty(LOW_TOTAL).addModifiableListener(this.totalListener);
        this.getProperty(HIGH_TOTAL).addModifiableListener(this.totalListener);
    }

    @Override
    protected void serviceRatioModified() {
        super.serviceRatioModified();
        this.updatePrices(this.getProduct());
    }

    protected void updatePrices(Product product) {
        if (TypeHelper.isA((IMObject)product, (String)"product.template")) {
            Property fixedPrice = this.getProperty(FIXED_PRICE);
            Property lowUnitPrice = this.getProperty(LOW_UNIT_PRICE);
            Property highUnitPrice = this.getProperty(HIGH_UNIT_PRICE);
            fixedPrice.setValue((Object)BigDecimal.ZERO);
            lowUnitPrice.setValue((Object)BigDecimal.ZERO);
            highUnitPrice.setValue((Object)BigDecimal.ZERO);
        } else {
            Property fixedPrice = this.getProperty(FIXED_PRICE);
            Property lowUnitPrice = this.getProperty(LOW_UNIT_PRICE);
            Property highUnitPrice = this.getProperty(HIGH_UNIT_PRICE);
            ProductPrice fixed = null;
            ProductPrice unit = null;
            BigDecimal serviceRatio = this.getServiceRatio();
            if (product != null) {
                fixed = this.getDefaultFixedProductPrice(product);
                unit = this.getDefaultUnitProductPrice(product);
            }
            if (fixed != null) {
                fixedPrice.setValue((Object)this.getPrice(product, fixed, serviceRatio));
            } else {
                fixedPrice.setValue((Object)BigDecimal.ZERO);
            }
            if (unit != null) {
                BigDecimal price = this.getPrice(product, unit, serviceRatio);
                lowUnitPrice.setValue((Object)price);
                highUnitPrice.setValue((Object)price);
            } else {
                lowUnitPrice.setValue((Object)BigDecimal.ZERO);
                highUnitPrice.setValue((Object)BigDecimal.ZERO);
            }
        }
        this.calculateLowTotal();
        this.calculateHighTotal();
    }

    @Override
    protected BigDecimal getFixedCost() {
        ProductPrice price = this.getFixedProductPrice(this.getProduct());
        return this.getCostPrice(price);
    }

    @Override
    protected BigDecimal getUnitCost() {
        ProductPrice price = this.getUnitProductPrice(this.getProduct());
        return this.getCostPrice(price);
    }

    @Override
    protected boolean updateDiscount() {
        boolean updated = this.recalculateLow();
        return updated |= this.recalculateHigh();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatioEditor) {
        return new EstimateItemLayoutStrategy(fixedPrice, serviceRatioEditor);
    }

    private void calculateLowTotal() {
        BigDecimal fixedPrice = this.getFixedPrice();
        BigDecimal unitPrice = this.getLowUnitPrice();
        BigDecimal quantity = this.getLowQuantity();
        BigDecimal discount = this.getLowDiscount();
        BigDecimal total = this.getEditContext().calculateTotal(fixedPrice, unitPrice, quantity, discount);
        this.getProperty(LOW_TOTAL).setValue((Object)total);
    }

    private void calculateHighTotal() {
        BigDecimal fixedPrice = this.getFixedPrice();
        BigDecimal unitPrice = this.getHighUnitPrice();
        BigDecimal quantity = this.getHighQuantity();
        BigDecimal discount = this.getHighDiscount();
        BigDecimal total = this.getEditContext().calculateTotal(fixedPrice, unitPrice, quantity, discount);
        this.getProperty(HIGH_TOTAL).setValue((Object)total);
    }

    private void onLowQuantityChanged() {
        BigDecimal minQuantity = this.getMinimumQuantity();
        BigDecimal quantity = this.getLowQuantity();
        if (this.lowQuantity.getProperty().isValid() && (quantity.compareTo(minQuantity) < 0 || MathRules.isZero((BigDecimal)quantity))) {
            this.setMinimumQuantity(quantity);
        }
    }

    private void updateLayout(Product product, boolean showPrint) {
        ArchetypeNodes expectedFilter;
        ArchetypeNodes currentNodes = this.getArchetypeNodes();
        if (!Objects.equals(currentNodes, expectedFilter = this.getFilterForProduct(product, showPrint))) {
            Component focus = FocusHelper.getFocus();
            Property focusProperty = null;
            if (focus instanceof BoundProperty) {
                focusProperty = ((BoundProperty)focus).getProperty();
            }
            this.changeLayout(expectedFilter);
            if (focusProperty != null) {
                if (!this.setFocus(focusProperty)) {
                    this.moveFocusToProduct();
                }
            } else {
                this.moveFocusToProduct();
            }
        }
    }

    private void updateSellingUnits(Product product) {
        String node;
        IMObjectBean bean;
        String units = "";
        if (product != null && (bean = this.getBean((IMObject)product)).hasNode(node = "sellingUnits")) {
            units = LookupNameHelper.getName((IMObject)product, (String)node);
        }
        this.lowQtySellingUnits.setText(units);
        this.highQtySellingUnits.setText(units);
    }

    private boolean recalculateLow() {
        boolean result = false;
        Property discount = this.getProperty(LOW_DISCOUNT);
        discount.removeModifiableListener(this.lowDiscountListener);
        try {
            BigDecimal unitPrice = this.getLowUnitPrice();
            BigDecimal quantity = this.getLowQuantity();
            BigDecimal amount = this.calculateDiscount(unitPrice, quantity);
            if (this.disableDiscounts() || !MathRules.isZero((BigDecimal)amount) || MathRules.isZero((BigDecimal)quantity)) {
                result = discount.setValue((Object)amount);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.calculateLowTotal();
        discount.addModifiableListener(this.lowDiscountListener);
        return result;
    }

    private boolean recalculateHigh() {
        boolean result = false;
        Property discount = this.getProperty(HIGH_DISCOUNT);
        discount.removeModifiableListener(this.highDiscountListener);
        try {
            BigDecimal unitPrice = this.getHighUnitPrice();
            BigDecimal quantity = this.getHighQuantity();
            BigDecimal amount = this.calculateDiscount(unitPrice, quantity);
            if (this.disableDiscounts() || !MathRules.isZero((BigDecimal)amount) || MathRules.isZero((BigDecimal)quantity)) {
                result = discount.setValue((Object)amount);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.calculateHighTotal();
        discount.addModifiableListener(this.highDiscountListener);
        return result;
    }

    private void onTotalChanged() {
        Product product = this.getProduct();
        boolean showPrint = this.updatePrint(product);
        this.updateLayout(product, showPrint);
    }

    private boolean updatePrint(Product product) {
        boolean result = false;
        if (product != null) {
            BigDecimal lowTotal = this.getLowTotal();
            BigDecimal highTotal = this.getHighTotal();
            boolean bl = result = MathRules.equals((BigDecimal)lowTotal, (BigDecimal)BigDecimal.ZERO) && MathRules.equals((BigDecimal)highTotal, (BigDecimal)BigDecimal.ZERO);
            if (result) {
                Product template = this.getTemplate();
                if (template != null) {
                    IMObjectBean bean = this.getBean((IMObject)template);
                    result = !bean.getBoolean("printAggregate");
                }
            } else {
                this.setPrint(true);
            }
        }
        return result;
    }

    private ArchetypeNodes getFilterForProduct(Product product, boolean showPrint) {
        ArchetypeNodes result = null;
        if (TypeHelper.isA((IMObject)product, (String)"template")) {
            result = TEMPLATE_NODES;
        } else {
            if (this.disableDiscounts()) {
                result = new ArchetypeNodes().exclude(new String[]{LOW_DISCOUNT, HIGH_DISCOUNT});
            }
            if (showPrint) {
                if (result == null) {
                    result = new ArchetypeNodes();
                }
                result.simple(new String[]{"print"});
                result.order("print", LOW_TOTAL);
            }
            if (this.showServiceRatio()) {
                if (result == null) {
                    result = new ArchetypeNodes();
                }
                result.simple(new String[]{"serviceRatio"}).hidden(true);
            }
        }
        return result;
    }

    protected class EstimateItemLayoutStrategy
    extends PriceActItemEditor.PriceItemLayoutStrategy {
        public EstimateItemLayoutStrategy(FixedPriceEditor fixedPrice, PriceActItemEditor.ServiceRatioEditor serviceRatioEditor) {
            super(EstimateItemEditor.this, fixedPrice, (PropertyEditor)serviceRatioEditor);
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            this.addComponent(this.createQuantity(EstimateItemEditor.this.lowQuantity, EstimateItemEditor.this.lowQtySellingUnits));
            this.addComponent(this.createQuantity(EstimateItemEditor.this.highQuantity, EstimateItemEditor.this.highQtySellingUnits));
            return super.apply(object, properties, parent, context);
        }

        protected ComponentState createQuantity(Quantity quantity, Label units) {
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{quantity.getComponent(), units});
            return new ComponentState((Component)row, quantity.getProperty());
        }
    }
}

