/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.credit;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.finance.account.BalanceCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

public class ChargeAllocationTableModel
extends DescriptorTableModel<FinancialAct> {
    private final BalanceCalculator calculator = new BalanceCalculator((IArchetypeService)ServiceHelper.getArchetypeService());
    private int toPayIndex;

    public ChargeAllocationTableModel(LayoutContext context) {
        this(CustomerAccountArchetypes.DEBITS.toArray(new String[0]), context);
    }

    public ChargeAllocationTableModel(String[] archetypes, LayoutContext context) {
        super(archetypes, context);
    }

    protected Object getValue(FinancialAct object, TableColumn column, int row) {
        if (column.getModelIndex() == this.toPayIndex) {
            BigDecimal amount = this.calculator.getAllocatable(object);
            String value = NumberFormatter.format((Number)amount, (NumberFormat)NumberFormatter.getCurrencyFormat());
            return TableHelper.rightAlign((String)value);
        }
        return super.getValue((IMObject)object, column, row);
    }

    protected ArchetypeNodes getArchetypeNodes() {
        return ArchetypeNodes.onlySimple((String[])new String[]{"id", "startTime", "amount", "allocatedAmount", "clinician", "notes"}).hidden(true);
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        DescriptorTableColumn paid = this.getColumn((TableColumnModel)model, "allocatedAmount");
        paid.setHeaderValue((Object)Messages.get((String)"customer.credit.paid"));
        this.toPayIndex = this.getNextModelIndex((TableColumnModel)model);
        TableColumn toPay = new TableColumn(this.toPayIndex);
        toPay.setHeaderValue((Object)Messages.get((String)"customer.credit.topay"));
        this.addColumnAfter(toPay, paid.getModelIndex(), (TableColumnModel)model);
        return model;
    }
}

