/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.act.AbstractActTableModel;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class CommunicationTableModel
extends AbstractActTableModel<Act> {
    private static final String[] NODES = new String[]{"startTime", "description", "createdBy", "address", "reason", "location"};

    public CommunicationTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
    }

    protected String[] getNodeNames() {
        return NODES;
    }

    protected Object getValue(Act object, DescriptorTableColumn column, int row) {
        Object result = "startTime".equals(column.getName()) ? this.getCreatedTime(object) : ("address".equals(column.getName()) ? this.getAddress(object) : super.getValue((IMObject)object, column, row));
        return result;
    }

    private String getAddress(Act act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        String result = null;
        if (bean.hasNode("address")) {
            result = bean.getString("address");
            if (!StringUtils.isEmpty((CharSequence)result)) {
                String abbr = StringUtils.substringBefore((String)result, (String)"\n");
                if (result.length() != abbr.length()) {
                    result = abbr + "...";
                }
            }
        } else if (bean.hasNode("phone")) {
            result = bean.getString("phone");
        }
        return result;
    }

    private String getCreatedTime(Act act) {
        Date date = act.getCreated();
        return date != null ? DateFormatter.formatDateTimeAbbrev((Date)date) : null;
    }
}

