/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.PatientReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public class CommunicationQuery
extends DateRangeActQuery<Act> {
    private final SimpleProperty patient;
    private final PatientReferenceEditor patientSelector;
    private static final String[] ARCHETYPES = new String[]{"act.customerCommunication*", "act.smsMessage", "act.smsReply"};

    public CommunicationQuery(Party customer, LayoutContext context) {
        super((Entity)customer, "customer", "participation.customer", ARCHETYPES, Act.class);
        String displayName = DescriptorHelper.getDisplayName((String)"act.customerCommunicationEmail", (String)"patient", (ArchetypeService)this.getService());
        this.patient = new SimpleProperty(displayName, IMObjectReference.class);
        this.patient.setArchetypeRange(new String[]{"party.patientpet"});
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(context.getContext()), context.getHelpContext());
        this.patientSelector = new PatientReferenceEditor((Property)this.patient, null, (LayoutContext)layoutContext);
        this.setAuto(true);
    }

    public IConstraint getConstraints() {
        Reference patientRef = this.patient.getReference();
        if (patientRef != null) {
            return new ParticipantConstraint("patient", "participation.patient", patientRef);
        }
        return null;
    }

    protected void doLayout(Component container) {
        Label patientLabel = LabelFactory.create();
        patientLabel.setText(this.patient.getDisplayName());
        container.add((Component)patientLabel);
        container.add(this.patientSelector.getComponent());
        FocusGroup group = this.getFocusGroup();
        group.add(this.patientSelector.getFocusGroup());
        super.doLayout(container);
        group.setFocus();
    }
}

