/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderDialog;

public class UndispensedOrderChecker {
    private final IArchetypeService service = (IArchetypeService)ServiceHelper.getBean(IArchetypeService.class);
    private final List<Act> items;

    public UndispensedOrderChecker(Act charge) {
        this.items = this.getUndispensedItems(charge);
    }

    public UndispensedOrderChecker(CustomerChargeActEditor editor) {
        this.items = this.getUndispensedItems(editor);
    }

    public boolean hasUndispensedItems() {
        return !this.items.isEmpty();
    }

    public List<Act> getUndispensedItems() {
        return this.items;
    }

    public void confirm(HelpContext help, Runnable listener) {
        this.confirm(help, listener, null);
    }

    public void confirm(HelpContext help, final Runnable confirmed, final Runnable cancelled) {
        if (!this.items.isEmpty()) {
            UndispensedOrderDialog dialog = new UndispensedOrderDialog(this.items, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    confirmed.run();
                }

                public void onCancel() {
                    if (cancelled != null) {
                        cancelled.run();
                    }
                }
            });
            dialog.show();
        } else {
            confirmed.run();
        }
    }

    private List<Act> getUndispensedItems(Act charge) {
        List<Act> items = Collections.emptyList();
        if (charge.isA("act.customerAccountChargesInvoice")) {
            IMObjectBean bean = this.service.getBean((IMObject)charge);
            items = new ArrayList<Act>();
            for (Act item : bean.getTargets("items", Act.class)) {
                BigDecimal received;
                BigDecimal quantity;
                IMObjectBean itemBean = this.service.getBean((IMObject)item);
                boolean ordered = "ORDERED".equalsIgnoreCase(item.getStatus());
                if (!ordered || MathRules.equals((BigDecimal)(quantity = itemBean.getBigDecimal("quantity", BigDecimal.ZERO)), (BigDecimal)(received = itemBean.getBigDecimal("receivedQuantity", BigDecimal.ZERO)))) continue;
                items.add(item);
            }
        }
        return items;
    }

    private List<Act> getUndispensedItems(CustomerChargeActEditor editor) {
        List<Act> items = Collections.emptyList();
        if (editor.getObject().isA("act.customerAccountChargesInvoice") && "POSTED".equals(editor.getStatus())) {
            items = editor.getNonDispensedItems();
        }
        return items;
    }
}

