/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.StockOnHand;

public class StockQuantity {
    private final SimpleProperty property = new SimpleProperty("onHand", null, BigDecimal.class, Messages.get((String)"product.stock.onhand"), true);
    private final ComponentState state;
    private final FinancialAct act;
    private final StockOnHand stockOnHand;

    public StockQuantity(FinancialAct act, StockOnHand stockOnHand, LayoutContext context) {
        this.act = act;
        Component component = context.getComponentFactory().create((Property)this.property);
        this.state = new ComponentState(component, (Property)this.property);
        this.stockOnHand = stockOnHand;
    }

    public ComponentState getComponent() {
        return this.state;
    }

    public void refresh() {
        Component component = this.state.getComponent();
        BigDecimal stock = this.stockOnHand.getAvailableStock(this.act);
        this.property.setValue((Object)stock);
        if (stock != null && stock.compareTo(BigDecimal.ZERO) <= 0) {
            component.setStyleName("OutOfStock");
        } else {
            component.setStyleName("edit");
        }
    }
}

