/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.ReloadTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.workflow.payment.PaymentWorkflow;

public class PostedChargeWorkflow
extends WorkflowImpl {
    private final TaskContext initial;

    public PostedChargeWorkflow(FinancialAct charge, Context context, HelpContext help) {
        super(help);
        LocalContext local = LocalContext.copy((Context)context);
        IMObjectBean bean = this.getBean((IMObject)charge);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        local.setCustomer(customer);
        ContextHelper.setPatient((Context)local, (Party)context.getPatient(), (boolean)true);
        this.initial = new DefaultTaskContext((Context)local, help);
        this.initial.addObject((IMObject)charge);
        if (customer != null && charge.isA(new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter"}) && this.hasPositiveBalance(customer)) {
            this.addPaymentWorkflow(charge, (Context)local, help);
        }
        this.addPrintTask(charge, (Context)local);
    }

    public void start() {
        this.start(this.initial);
    }

    private void addPaymentWorkflow(FinancialAct charge, Context context, HelpContext help) {
        BigDecimal total = charge.getTotal();
        PaymentWorkflow payment = new PaymentWorkflow(total, context, help);
        payment.setRequired(false);
        this.addTask((Task)payment);
        this.addTask((Task)new ReloadTask(charge.getArchetype()));
    }

    private void addPrintTask(FinancialAct charge, Context context) {
        BillingCustomerMailContext mailContext = new BillingCustomerMailContext(context);
        PrintActTask print = new PrintActTask(charge.getArchetype(), (MailContext)mailContext);
        print.setRequired(false);
        print.setEnableSkip(false);
        this.addTask((Task)print);
    }

    private boolean hasPositiveBalance(Party customer) {
        CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
        BigDecimal balance = rules.getBalance(customer);
        return balance.compareTo(BigDecimal.ZERO) > 0;
    }
}

