/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.order.OrderCharger;

public class OrderChargeManager {
    private final OrderCharger charger;
    private final AlertListener listener;
    private String alertId;

    public OrderChargeManager(OrderCharger charger, AlertListener listener) {
        this.charger = charger;
        this.listener = listener;
    }

    public void check() {
        this.cancelAlert();
        if (this.charger.hasOrders()) {
            this.alertId = this.listener.onAlert(Messages.format((String)"customer.order.pending", (Object[])new Object[]{this.charger.getCustomer().getName()}));
        }
    }

    public void charge(final CustomerChargeActEditor editor) {
        this.chargeCompleted(editor);
        if (this.charger.hasOrders()) {
            String title = Messages.get((String)"customer.order.incomplete.title");
            String prompt = Messages.format((String)"customer.order.incomplete.message", (Object[])new Object[]{this.charger.getCustomer().getName()});
            ConfirmationDialog dialog = new ConfirmationDialog(title, prompt, ConfirmationDialog.YES_NO);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    OrderChargeManager.this.chargeSelected(editor);
                }
            });
            editor.queue((PopupDialog)dialog);
        }
    }

    public void chargeCompleted(CustomerChargeActEditor editor) {
        this.cancelAlert();
        int beforeOrders = 0;
        int afterOrders = 0;
        int beforeReturns = 0;
        int afterReturns = 0;
        if (editor != null) {
            beforeOrders = this.charger.getChargedOrders();
            beforeReturns = this.charger.getChargedReturns();
            this.charger.chargeComplete(editor);
            afterOrders = this.charger.getChargedOrders();
            afterReturns = this.charger.getChargedReturns();
        }
        StringBuilder buffer = new StringBuilder();
        if (this.charger.hasOrders()) {
            buffer.append(Messages.format((String)"customer.order.pending", (Object[])new Object[]{this.charger.getCustomer().getName()}));
        }
        if (beforeOrders != afterOrders) {
            if (buffer.length() != 0) {
                buffer.append("\n\n");
            }
            buffer.append(Messages.format((String)"customer.order.charged.order", (Object[])new Object[]{afterOrders - beforeOrders}));
        }
        if (beforeReturns != afterReturns) {
            if (buffer.length() != 0) {
                buffer.append("\n\n");
            }
            buffer.append(Messages.format((String)"customer.order.charged.return", (Object[])new Object[]{afterReturns - beforeReturns}));
        }
        if (buffer.length() != 0) {
            this.alertId = this.listener.onAlert(buffer.toString());
        }
    }

    public void chargeSelected(CustomerChargeActEditor editor) {
        this.charger.charge(editor, this::check);
    }

    public void save() {
        this.charger.save();
    }

    public void clear() {
        this.charger.clear();
    }

    private void cancelAlert() {
        if (this.alertId != null) {
            this.listener.cancel(this.alertId);
            this.alertId = null;
        }
    }
}

