/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.List;
import java.util.Map;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.AbstractChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.ChargeRemovalStates;
import org.openvpms.web.workspace.customer.charge.ChargeRemoveConfirmationHandler;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.InvoiceItemRemovalStates;
import org.openvpms.web.workspace.patient.investigation.PatientInvestigationActEditor;

public class InvoiceRemoveConfirmationHandler
extends ChargeRemoveConfirmationHandler {
    private final InvestigationManager manager;

    public InvoiceRemoveConfirmationHandler(InvestigationManager manager, Context context, HelpContext help) {
        super(context, help);
        this.manager = manager;
    }

    @Override
    protected ChargeRemovalStates getRemovalStates(List<IMObject> objects, AbstractChargeItemRelationshipCollectionEditor collection) {
        FinancialAct item;
        InvoiceItemRemovalStates result = new InvoiceItemRemovalStates(this.manager);
        for (IMObject iMObject : objects) {
            CustomerChargeActItemEditor itemEditor;
            item = (FinancialAct)iMObject;
            if (!this.checkRemovalState((Act)item, collection, result) || (itemEditor = (CustomerChargeActItemEditor)collection.getEditor((IMObject)item)) == null) continue;
            result.determineAffectedInvestigations(itemEditor);
        }
        for (Map.Entry entry : result.getAffectedEditorsByInvoiceItem().entrySet()) {
            item = (FinancialAct)entry.getKey();
            List editors = (List)entry.getValue();
            for (PatientInvestigationActEditor editor : editors) {
                String message;
                String displayName = this.getDisplayName(editor);
                if (editor.canEdit()) {
                    if (result.hasNoMoreTests(editor)) {
                        message = Messages.format((String)"customer.charge.delete.investigation.remove", (Object[])new Object[]{displayName});
                        result.addStatus((Act)item, ChargeRemovalStates.Status.OK, message);
                        continue;
                    }
                    message = Messages.format((String)"customer.charge.delete.investigation.removetest", (Object[])new Object[]{displayName});
                    result.addStatus((Act)item, ChargeRemovalStates.Status.OK, message);
                    continue;
                }
                message = Messages.format((String)"customer.charge.delete.investigation.cancel", (Object[])new Object[]{displayName});
                result.addStatus((Act)item, ChargeRemovalStates.Status.OK, message);
            }
        }
        return result;
    }

    private String getDisplayName(PatientInvestigationActEditor editor) {
        Entity investigationType = editor.getInvestigationType();
        return investigationType != null ? investigationType.getName() : Messages.format((String)"imobject.none", (Object[])new Object[0]);
    }
}

