/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.laboratory.service.OrderValidationStatus;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.IMObjectSelections;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.MultiSelectTableBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;

class InvestigationOrderDialog
extends ModalDialog {
    public static final String SUBMIT_ID = "button.submit";
    private final InvestigationManager manager;
    private final LayoutContext context;
    private final IMObjectSelections<DocumentAct> selections;
    private MultiSelectTableBrowser<DocumentAct> browser;

    public InvestigationOrderDialog(InvestigationManager manager, LayoutContext context, boolean skip) {
        String[] stringArray;
        String string = Messages.get((String)"customer.charge.investigation.submit.title");
        if (skip) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = SUBMIT_ID;
            stringArray2[1] = "skip";
            stringArray = stringArray2;
            stringArray2[2] = "cancel";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = SUBMIT_ID;
            stringArray = stringArray3;
            stringArray3[1] = "cancel";
        }
        super(string, stringArray);
        this.setModal(true);
        this.manager = manager;
        this.context = new DefaultLayoutContext(context);
        context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(this.context));
        this.selections = new IMObjectSelections();
        this.selections.setListener(this::updateSubmit);
        this.resize("InvestigationOrderDialog.size");
    }

    public List<DocumentAct> getSelections() {
        return new ArrayList<DocumentAct>(this.selections.getSelected());
    }

    protected void doLayout() {
        List<DocumentAct> investigations = this.manager.getUnconfirmedLaboratoryInvestigations();
        for (DocumentAct act : investigations) {
            if ("CONFIRM_DEFERRED".equals(act.getStatus2())) continue;
            this.selections.setSelected((IMObject)act, true);
        }
        ListQuery query = new ListQuery(investigations, "act.patientInvestigation", DocumentAct.class);
        DefaultDescriptorTableModel model = new DefaultDescriptorTableModel("act.patientInvestigation", this.context, new String[]{"startTime", "investigationType", "status2", "clinician"});
        this.browser = new MultiSelectTableBrowser((Query)query, (IMTableModel)model, this.selections, this.context);
        this.getLayout().add(this.browser.getComponent());
        this.updateSubmit();
    }

    protected void onButton(String button) {
        if (SUBMIT_ID.equals(button)) {
            this.validateInvestigations();
        } else {
            super.onButton(button);
        }
    }

    private void updateSubmit() {
        this.getButtons().setEnabled(SUBMIT_ID, !this.selections.getSelected().isEmpty());
    }

    private void validateInvestigations() {
        this.validateInvestigations(this.getSelections().iterator());
    }

    private void validateInvestigations(Iterator<DocumentAct> iterator) {
        if (iterator.hasNext()) {
            DocumentAct investigation = iterator.next();
            if (this.needsValidation(investigation)) {
                this.validate(investigation, iterator);
            } else {
                this.validateInvestigations(iterator);
            }
        } else if (!this.getSelections().isEmpty()) {
            super.onButton(SUBMIT_ID);
        } else if (this.getButtons().isEnabled("skip")) {
            this.onSkip();
        } else {
            this.onCancel();
        }
    }

    private boolean needsValidation(DocumentAct investigation) {
        return "PENDING".equals(investigation.getStatus2());
    }

    private void validate(DocumentAct investigation, Iterator<DocumentAct> iterator) {
        OrderValidationService.ValidationStatus status = this.manager.validate(investigation);
        if (status.getStatus() == OrderValidationStatus.Status.ERROR) {
            String preamble = this.getMessage(investigation, status, "customer.charge.investigation.submit.error");
            ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().preamble(preamble)).message(status.getMessage())).ok(() -> this.browser.deselect((IMObject)investigation))).show();
        } else if (status.getStatus() == OrderValidationStatus.Status.WARNING) {
            String preamble = this.getMessage(investigation, status, "customer.charge.investigation.submit.warning");
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("customer.charge.investigation.submit.confirm", new Object[0])).preamble(preamble)).message(status.getMessage())).yesNoCancel()).yes(() -> this.validateInvestigations(iterator))).no(() -> {
                this.browser.deselect((IMObject)investigation);
                this.validateInvestigations(iterator);
            })).cancel(() -> ((InvestigationOrderDialog)this).onCancel())).show();
        } else {
            this.validateInvestigations(iterator);
        }
    }

    private String getMessage(DocumentAct investigation, OrderValidationService.ValidationStatus status, String key) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)investigation);
        String patient = this.getPatient(bean);
        String investigationType = this.getInvestigationType(bean);
        return Messages.format((String)key, (Object[])new Object[]{investigationType, patient, status.getName()});
    }

    private String getPatient(IMObjectBean bean) {
        return IMObjectHelper.getName((Reference)bean.getTargetRef("patient"));
    }

    private String getInvestigationType(IMObjectBean bean) {
        return IMObjectHelper.getName((Reference)bean.getTargetRef("investigationType"));
    }
}

