/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.workspace.customer.CustomerFinancialWorkspace;
import org.openvpms.web.workspace.customer.account.CustomerAccountActTableModel;
import org.openvpms.web.workspace.customer.account.CustomerAccountQuery;
import org.openvpms.web.workspace.customer.charge.ChargeCRUDWindow;

public class ChargeWorkspace
extends CustomerFinancialWorkspace<FinancialAct> {
    private static final ActStatuses STATUSES = new ActStatuses("act.customerAccountChargesInvoice", "POSTED");
    private static final String[] CUSTOMER_SHORT_NAMES = new String[]{"party.customer*", "party.organisationOTC"};

    public ChargeWorkspace(Context context, Preferences preferences) {
        super("customer.charge", context, preferences);
        this.setArchetypes(Party.class, CUSTOMER_SHORT_NAMES);
        this.setChildArchetypes(FinancialAct.class, new String[]{"act.customerAccountCharges*"});
    }

    protected CRUDWindow<FinancialAct> createCRUDWindow() {
        return new ChargeCRUDWindow((Archetypes<FinancialAct>)this.getChildArchetypes(), this.getContext(), this.getHelpContext());
    }

    protected ActQuery<FinancialAct> createQuery() {
        return new CustomerAccountQuery((Party)this.getObject(), this.getChildArchetypes().getShortNames(), STATUSES, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    protected void onSaved(FinancialAct object, boolean isNew) {
        super.onSaved((IMObject)object, isNew);
        if ("POSTED".equals(object.getStatus())) {
            this.onBrowserSelected(null);
        }
    }

    protected Browser<FinancialAct> createBrowser(Query<FinancialAct> query) {
        CustomerAccountActTableModel model = new CustomerAccountActTableModel(true, false);
        return BrowserFactory.create(query, null, model, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }
}

