/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientHistoryChanges;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.workspace.patient.mr.PatientDocumentActEditor;

public class ChargeSaveContext
implements CollectionPropertyEditor.RemoveHandler {
    private final IArchetypeService service;
    private final LayoutContext context;
    private PatientHistoryChanges changes;
    private final List<IMObject> toRemove = new ArrayList<IMObject>();
    private final List<DocumentAct> documentsToRemove = new ArrayList<DocumentAct>();
    private final List<IMObjectEditor> toRemoveEditors = new ArrayList<IMObjectEditor>();

    ChargeSaveContext(IArchetypeService service, LayoutContext context) {
        this.service = service;
        this.context = context;
    }

    public void setHistoryChanges(PatientHistoryChanges changes) {
        this.changes = changes;
    }

    public PatientHistoryChanges getHistoryChanges() {
        return this.changes;
    }

    public void remove(IMObject object) {
        if (object.isA("act.patientDocument*")) {
            this.documentsToRemove.add((DocumentAct)object);
        } else {
            this.toRemove.add(object);
        }
    }

    public void remove(IMObjectEditor editor) {
        this.toRemoveEditors.add(editor);
    }

    public void save() {
        for (DocumentAct document : this.documentsToRemove) {
            this.changes.removeRelationship((Act)document);
        }
        for (IMObjectEditor editor : this.toRemoveEditors) {
            IMObject object = editor.getObject();
            if (!(editor instanceof DocumentAct)) continue;
            this.changes.removeRelationship((Act)((DocumentAct)object));
        }
        this.changes.save();
        for (IMObject iMObject : this.toRemove.toArray(new IMObject[0])) {
            this.service.remove(iMObject);
            this.toRemove.remove(iMObject);
        }
        for (IMObject iMObject : this.documentsToRemove.toArray(new DocumentAct[0])) {
            if (!iMObject.isNew()) {
                PatientDocumentActEditor editor = new PatientDocumentActEditor((DocumentAct)iMObject, null, this.context);
                editor.delete();
            }
            this.documentsToRemove.remove(iMObject);
        }
        for (IMObject iMObject : this.toRemoveEditors.toArray(new IMObjectEditor[0])) {
            iMObject.delete();
            this.toRemoveEditors.remove(iMObject);
        }
    }
}

