/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.DefaultListMarkModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.component.im.table.MarkablePagedIMObjectTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

public class ChargeRemovalStates {
    private final Map<Act, ChargeState> states = new LinkedHashMap<Act, ChargeState>();

    public void addStatus(Act act, Status status, String message) {
        ChargeState chargeState = this.states.computeIfAbsent(act, k -> new ChargeState());
        chargeState.addStatus(status, message);
    }

    public boolean prompt() {
        return !this.states.isEmpty();
    }

    public boolean canDelete(Act object) {
        return this.states.get(object).getStatus() != Status.FORBIDDEN;
    }

    public void show(String name, final Consumer<Collection<Act>> toRemove, final Runnable cancel, LayoutContext context) {
        String message;
        String title;
        List<Act> acts = this.getObjects();
        int forbidden = 0;
        int override = 0;
        for (ChargeState state : this.states.values()) {
            switch (state.getStatus()) {
                case FORBIDDEN: {
                    ++forbidden;
                    break;
                }
                case OVERRIDE: {
                    ++override;
                }
            }
        }
        if (forbidden == this.states.size()) {
            title = Messages.format((String)"customer.charge.delete.forbidden.title", (Object[])new Object[]{name});
            message = Messages.format((String)"customer.charge.delete.forbidden", (Object[])new Object[]{this.states.size()});
        } else {
            title = Messages.format((String)"imobject.collection.delete.title", (Object[])new Object[]{name});
            message = forbidden > 0 ? Messages.format((String)"customer.charge.delete.someforbidden", (Object[])new Object[]{name}) : (override > 0 ? Messages.format((String)"customer.charge.delete.override", (Object[])new Object[]{name}) : Messages.format((String)"customer.charge.delete.confirm", (Object[])new Object[]{name}));
        }
        final DeleteDialog dialog = new DeleteDialog(title, message, new ArrayList<Act>(acts), context);
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                toRemove.accept(dialog.getSelections());
            }

            public void onCancel() {
                cancel.run();
            }
        });
        dialog.show();
    }

    protected IMObjectTableModel<Act> createModel(String archetype, LayoutContext context) {
        return new ChargeModel(archetype, context);
    }

    protected List<Act> getObjects() {
        return new ArrayList<Act>(this.states.keySet());
    }

    private static class ChargeState {
        private final List<StatusMessage> statusMessages = new ArrayList<StatusMessage>();

        private ChargeState() {
        }

        public void addStatus(Status status, String message) {
            this.statusMessages.add(new StatusMessage(status, message));
        }

        public Status getStatus() {
            Status result = Status.OK;
            for (StatusMessage statusMessage : this.statusMessages) {
                if (statusMessage.status.compareTo(result) <= 0) continue;
                result = statusMessage.status;
            }
            return result;
        }

        public List<String> getMessages() {
            ArrayList<String> result = new ArrayList<String>();
            for (StatusMessage statusMessage : this.statusMessages) {
                if (statusMessage.message == null) continue;
                result.add(statusMessage.message);
            }
            return result;
        }
    }

    private static class StatusMessage {
        private final Status status;
        private final String message;

        public StatusMessage(Status status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    private class DeleteDialog
    extends ConfirmationDialog {
        private final List<Act> objects;
        private final LayoutContext context;
        private MarkablePagedIMObjectTableModel<Act> markableModel;

        DeleteDialog(String title, String message, List<Act> objects, LayoutContext context) {
            super(title, message, OK_CANCEL);
            this.setStyleName("ConfirmationDialog");
            this.objects = objects;
            this.context = context;
        }

        public List<Act> getSelections() {
            return this.markableModel.getMarked(this.objects);
        }

        protected void doLayout() {
            Label content = LabelFactory.create((boolean)true, (boolean)true);
            content.setText(this.getMessage());
            String archetype = this.objects.get(0).getArchetype();
            ListQuery query = new ListQuery(this.objects, archetype, false, Act.class);
            query.setMaxResults(7);
            final IMObjectTableModel<Act> model = ChargeRemovalStates.this.createModel(archetype, this.context);
            model.setRowMarkModel((ListMarkModel)new DefaultListMarkModel(){

                public boolean canMark(int index) {
                    Act object = (Act)model.getObjects().get(index);
                    return ChargeRemovalStates.this.canDelete(object);
                }
            });
            this.markableModel = new MarkablePagedIMObjectTableModel(model);
            for (Act object : this.objects) {
                this.markableModel.setMarked((Object)object, ((ChargeState)ChargeRemovalStates.this.states.get(object)).getStatus() == Status.OK);
            }
            PagedIMTable table = new PagedIMTable(this.markableModel);
            table.setResultSet((ResultSet)new ListResultSet(this.objects, 7));
            Column column = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{content, table.getComponent()});
            this.markableModel.getRowMarkModel().addListener(new ListMarkModel.Listener(){

                public void changed(int index, boolean marked) {
                    DeleteDialog.this.enableDelete();
                }

                public void cleared() {
                    DeleteDialog.this.enableDelete();
                }
            });
            this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
            this.enableDelete();
            this.resize();
        }

        protected void resize() {
            this.resize("ChargeRemovalConfirmationDialog.size");
        }

        private void enableDelete() {
            this.getButtons().setEnabled("ok", !this.markableModel.getRowMarkModel().isEmpty());
        }
    }

    protected class ChargeModel
    extends DefaultDescriptorTableModel<Act> {
        private int messageIndex;
        private static final String BULLET = "\u2022";

        public ChargeModel(String archetype, LayoutContext context) {
            super(archetype, context, new String[]{"startTime", "patient", "product"});
        }

        protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
            DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(shortNames, context);
            this.addColumns(model);
            return model;
        }

        protected void addColumns(DefaultTableColumnModel model) {
            this.messageIndex = this.getNextModelIndex((TableColumnModel)model);
            model.addColumn(new TableColumn(this.messageIndex));
            this.addMarkColumn((TableColumnModel)model);
        }

        protected Object getValue(Act object, TableColumn column, int row) {
            Object result = null;
            if (column.getModelIndex() == this.messageIndex) {
                ChargeState chargeState = (ChargeState)ChargeRemovalStates.this.states.get(object);
                if (chargeState != null) {
                    List<String> messages = chargeState.getMessages();
                    if (messages.size() == 1) {
                        result = LabelFactory.text((String)messages.get(0), (boolean)true);
                    } else if (messages.size() > 1) {
                        ComponentGrid grid = new ComponentGrid();
                        for (String message : messages) {
                            grid.add(new Component[]{LabelFactory.text((String)BULLET), LabelFactory.text((String)message)});
                        }
                        result = grid.createGrid();
                    }
                }
            } else {
                result = super.getValue((IMObject)object, column, row);
            }
            return result;
        }
    }

    public static enum Status {
        OK,
        OVERRIDE,
        FORBIDDEN;

    }
}

