/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.Date;
import java.util.function.Consumer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.action.ActionStatus;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.workspace.ActPoster;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.account.AccountActActions;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderChecker;

public class ChargePoster
extends ActPoster<FinancialAct> {
    private final LayoutContext context;

    public ChargePoster(FinancialAct act, AccountActActions actions, LayoutContext context) {
        super((Act)act, (ActActions)actions, context.getHelpContext());
        this.context = context;
    }

    protected void confirmPost(FinancialAct act, HelpContext help, Consumer<ActionStatus> listener) {
        if (act.isA("act.customerAccountChargesInvoice")) {
            UndispensedOrderChecker checker = new UndispensedOrderChecker((Act)act);
            if (checker.hasUndispensedItems()) {
                checker.confirm(help, () -> this.postConfirmed((Act)act, listener), () -> listener.accept(ActionStatus.success()));
            } else {
                super.confirmPost((Act)act, help, listener);
            }
        } else {
            super.confirmPost((Act)act, help, listener);
        }
    }

    protected void post(FinancialAct act, Consumer<ActionStatus> listener) {
        ActEditor editor = (ActEditor)this.context.getEditorFactory().create((IMObject)act, this.context);
        editor.setStatus("POSTED");
        editor.setStartTime(new Date());
        IMObjectEditorSaver saver = new IMObjectEditorSaver();
        if (saver.save((IMObjectEditor)editor, () -> listener.accept(ActionStatus.success()))) {
            listener.accept(ActionStatus.success());
        }
    }
}

