/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.payment;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

class PaymentChanges {
    private final IArchetypeService service;
    private final Map<FinancialAct, FinancialAct> changes = new LinkedHashMap<FinancialAct, FinancialAct>();

    public PaymentChanges(IArchetypeService service) {
        this.service = service;
    }

    public void addChange(FinancialAct previousPayment, FinancialAct newPayment) {
        if (!previousPayment.isNew()) {
            this.changes.put(newPayment, previousPayment);
        } else {
            this.changes.put(newPayment, this.changes.remove(previousPayment));
        }
    }

    public String getAuditMessage(String name, Date timestamp) {
        String result = null;
        if (!this.changes.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            String date = DateFormatter.formatDateTime((Date)timestamp);
            for (Map.Entry<FinancialAct, FinancialAct> entry : this.changes.entrySet()) {
                FinancialAct persistent = entry.getValue();
                if (builder.length() != 0) {
                    builder.append('\n');
                }
                builder.append(Messages.format((String)"customer.account.payment.audit", (Object[])new Object[]{date, name, DescriptorHelper.getDisplayName((IMObject)persistent, (ArchetypeService)this.service), NumberFormatter.formatCurrency((Number)persistent.getTotal()), DescriptorHelper.getDisplayName((IMObject)((IMObject)entry.getKey()), (ArchetypeService)this.service)}));
            }
            result = builder.toString();
            this.changes.clear();
        }
        return result;
    }
}

