/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.system.ServiceHelper;

public class ReverseConfirmationDialog
extends ConfirmationDialog {
    private final CheckBox hide;
    private final Property notesProperty;
    private final Property referenceProperty;

    public ReverseConfirmationDialog(String title, String message, HelpContext help, String notes, String reference, boolean canHide) {
        super(title, message, help);
        this.setStyleName("MediumDialog");
        ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor("act.customerAccountChargesInvoice");
        this.notesProperty = this.createProperty("notes", notes, archetype, 300);
        this.referenceProperty = this.createProperty("reference", reference, archetype, 20);
        this.hide = canHide ? CheckBoxFactory.create((String)"customer.account.reverse.hide", (boolean)true) : null;
    }

    public String getNotes() {
        return this.notesProperty.getString();
    }

    public String getReference() {
        return this.referenceProperty.getString();
    }

    public boolean getHide() {
        return this.hide != null && this.hide.isSelected();
    }

    protected void doLayout() {
        TextArea notesField = BoundTextComponentFactory.createTextArea((Property)this.notesProperty, (int)80, (int)5);
        notesField.setWidth(Styles.FULL_WIDTH);
        ActionListener listener = new ActionListener(){

            public void onAction(ActionEvent event) {
            }
        };
        notesField.addActionListener((nextapp.echo2.app.event.ActionListener)listener);
        TextField refField = BoundTextComponentFactory.create((Property)this.referenceProperty, (int)20);
        refField.addActionListener((nextapp.echo2.app.event.ActionListener)listener);
        Label message = LabelFactory.create(null, (String)"bold");
        message.setText(this.getMessage());
        ComponentState noteState = new ComponentState((Component)notesField, this.notesProperty);
        ComponentState refState = new ComponentState((Component)refField, this.referenceProperty);
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message, ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{noteState.getLabel(), notesField}), ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{refState.getLabel(), refField})});
        if (this.hide != null) {
            column.add((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{this.hide}));
        }
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
        FocusGroup group = this.getFocusGroup();
        group.add((Component)notesField);
        group.add((Component)refField);
        if (this.hide != null) {
            group.add((Component)this.hide);
        }
        group.setFocus();
    }

    private Property createProperty(String name, String value, ArchetypeDescriptor archetype, int defaultMaxLength) {
        NodeDescriptor noteDesc = archetype.getNodeDescriptor(name);
        int maxLength = defaultMaxLength;
        String displayName = null;
        if (noteDesc != null) {
            displayName = noteDesc.getDisplayName();
            maxLength = noteDesc.getMaxLength();
        }
        SimpleProperty property = new SimpleProperty(name, (Object)value, String.class, displayName, false);
        property.setMaxLength(maxLength);
        return property;
    }
}

