/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.finance.discount.DiscountRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.edit.act.TemplateProduct;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.FixedPriceEditor;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.charge.PriceActEditContext;

public abstract class PriceActItemEditor
extends ActItemEditor {
    public static final String MINIMUM_QUANTITY = "minQuantity";
    protected static final String SERVICE_RATIO = "serviceRatio";
    private final PriceActEditContext editContext;
    private final ServiceRatioEditor serviceRatioEditor;
    private final ModifiableListener serviceRatioListener;
    private final FixedPriceEditor fixedEditor;
    private BigDecimal availableServiceRatio;
    private ProductPrice unitProductPrice;

    public PriceActItemEditor(Act act, Act parent, PriceActEditContext context, LayoutContext layoutContext) {
        super(act, parent, layoutContext);
        this.editContext = context;
        Product product = this.getProduct();
        Property fixedPrice = this.getProperty("fixedPrice");
        this.availableServiceRatio = this.getAvailableServiceRatio(product);
        this.fixedEditor = new FixedPriceEditor(fixedPrice, context.getPricingContext());
        this.fixedEditor.setProduct(product, this.getServiceRatio());
        Property serviceRatio = this.getProperty(SERVICE_RATIO);
        this.serviceRatioEditor = new ServiceRatioEditor(serviceRatio);
        this.serviceRatioListener = modifiable -> this.serviceRatioModified();
        serviceRatio.addModifiableListener(this.serviceRatioListener);
        this.addEditor((Editor)this.fixedEditor);
        this.addEditor((Editor)this.serviceRatioEditor);
    }

    public BigDecimal getMinimumQuantity() {
        return this.getProperty(MINIMUM_QUANTITY).getBigDecimal(BigDecimal.ZERO);
    }

    public void setMinimumQuantity(BigDecimal quantity) {
        this.getProperty(MINIMUM_QUANTITY).setValue((Object)quantity);
    }

    public BigDecimal getFixedPrice() {
        return this.getProperty("fixedPrice").getBigDecimal(BigDecimal.ZERO);
    }

    public BigDecimal getServiceRatio() {
        return this.getProperty(SERVICE_RATIO).getBigDecimal();
    }

    public void setServiceRatio(BigDecimal serviceRatio) {
        this.getProperty(SERVICE_RATIO).setValue((Object)serviceRatio);
    }

    public BigDecimal getAvailableServiceRatio() {
        return this.availableServiceRatio;
    }

    public void setProduct(TemplateProduct product, Product template, int group) {
        this.setMinimumQuantity(null);
        super.setProduct(product, template, group);
        this.setMinimumQuantity(product != null ? product.getLowQuantity() : null);
    }

    public void moveFocusToProduct() {
        FocusGroup group;
        ProductParticipationEditor productEditor = this.getProductEditor();
        if (productEditor != null && (group = productEditor.getFocusGroup()) != null) {
            group.setFocus();
        }
    }

    protected boolean doValidation(Validator validator) {
        boolean result = super.doValidation(validator);
        if (result && this.editContext.useMinimumQuantities()) {
            result = this.validateMinimumQuantity(validator);
        }
        return result;
    }

    protected boolean validateMinimumQuantity(Validator validator) {
        boolean result = true;
        BigDecimal minQuantity = this.getMinimumQuantity();
        if (!MathRules.isZero((BigDecimal)minQuantity) && this.getQuantity().compareTo(minQuantity) < 0) {
            Product product = this.getProduct();
            String name = product != null ? product.getName() : null;
            Property property = this.getProperty("quantity");
            String message = Messages.format((String)"customer.charge.minquantity", (Object[])new Object[]{name, minQuantity});
            validator.add((Modifiable)property, new ValidatorError(property, message));
            result = false;
        }
        return result;
    }

    protected void doSave() {
        if (TypeHelper.isA((Reference)this.getProductRef(), (String)"product.template")) {
            Product product = this.getProduct();
            String name = product != null ? product.getName() : null;
            throw new IllegalStateException("Cannot save with product template: " + name);
        }
        this.saveObject();
        this.saveChildren();
    }

    protected void productModified(Product product) {
        super.productModified(product);
        this.updateServiceRatio(product);
    }

    protected void serviceRatioModified() {
        this.fixedEditor.setServiceRatio(this.getServiceRatio());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return this.createLayoutStrategy(this.fixedEditor, this.serviceRatioEditor);
    }

    protected IMObjectLayoutStrategy createLayoutStrategy(FixedPriceEditor fixedPrice, ServiceRatioEditor serviceRatioEditor) {
        return new PriceItemLayoutStrategy(fixedPrice, (PropertyEditor)serviceRatioEditor);
    }

    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.restrictProductSelection();
    }

    protected PriceActEditContext getEditContext() {
        return this.editContext;
    }

    protected BigDecimal getDose(Product product, Party patient) {
        return this.editContext.getDose(product, patient);
    }

    protected BigDecimal getFixedCost() {
        return this.getProperty("fixedCost").getBigDecimal(BigDecimal.ZERO);
    }

    protected BigDecimal getUnitCost() {
        return this.getProperty("unitCost").getBigDecimal(BigDecimal.ZERO);
    }

    protected BigDecimal getDiscount() {
        return this.getProperty("discount").getBigDecimal(BigDecimal.ZERO);
    }

    protected boolean disableDiscounts() {
        return this.editContext.disableDiscounts();
    }

    protected BigDecimal getFixedPriceMaxDiscount() {
        return this.getFixedPriceMaxDiscount(BigDecimal.ZERO);
    }

    protected BigDecimal getFixedPriceMaxDiscount(BigDecimal defaultValue) {
        BigDecimal result;
        Product product = this.getProduct();
        if (product != null) {
            ProductPrice price = this.getFixedProductPrice(product);
            result = this.getMaxDiscount(price);
        } else {
            result = defaultValue;
        }
        return result;
    }

    protected BigDecimal getUnitPriceMaxDiscount() {
        return this.getUnitPriceMaxDiscount(BigDecimal.ZERO);
    }

    protected BigDecimal getUnitPriceMaxDiscount(BigDecimal defaultValue) {
        BigDecimal result;
        Product product = this.getProduct();
        if (product != null) {
            ProductPrice price = this.getUnitProductPrice(product);
            result = this.getMaxDiscount(price);
        } else {
            result = defaultValue;
        }
        return result;
    }

    protected boolean updateDiscount() {
        boolean result = false;
        try {
            BigDecimal amount = this.calculateDiscount();
            if (this.disableDiscounts() || !MathRules.isZero((BigDecimal)amount) || MathRules.isZero((BigDecimal)this.getQuantity())) {
                Property discount = this.getProperty("discount");
                result = discount.setValue((Object)amount);
            }
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return result;
    }

    protected BigDecimal calculateDiscount() {
        BigDecimal unitPrice = this.getUnitPrice();
        BigDecimal quantity = this.getQuantity();
        return this.calculateDiscount(unitPrice, quantity);
    }

    protected BigDecimal calculateDiscount(BigDecimal unitPrice, BigDecimal quantity) {
        BigDecimal amount = BigDecimal.ZERO;
        if (!this.disableDiscounts()) {
            Party customer = this.getCustomer();
            Party patient = this.getPatient();
            Product product = this.getProduct();
            if (customer != null && product != null && !product.isA("product.template")) {
                BigDecimal fixedCost = this.getFixedCost();
                BigDecimal unitCost = this.getUnitCost();
                BigDecimal fixedPrice = this.getFixedPrice();
                BigDecimal fixedPriceMaxDiscount = this.getFixedPriceMaxDiscount();
                BigDecimal unitPriceMaxDiscount = this.getUnitPriceMaxDiscount();
                Date startTime = this.getStartTime();
                if (startTime == null) {
                    Act parent = (Act)this.getParent();
                    startTime = parent.getActivityStartTime();
                }
                DiscountRules rules = this.editContext.getDiscountRules();
                amount = rules.calculateDiscount(startTime, this.editContext.getPractice(), customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity, fixedPriceMaxDiscount, unitPriceMaxDiscount);
            }
        }
        return amount;
    }

    protected ProductPrice getDefaultFixedProductPrice(Product product) {
        return this.getProductPrice("productPrice.fixedPrice", product);
    }

    protected ProductPrice getFixedProductPrice(Product product) {
        ProductPrice result = this.fixedEditor.getProductPrice();
        result = this.getProductPrice(product, "productPrice.fixedPrice", result, this.getFixedPrice(), this.getServiceRatio());
        this.fixedEditor.setProductPrice(result);
        return result;
    }

    protected ProductPrice getDefaultUnitProductPrice(Product product) {
        return this.getProductPrice("productPrice.unitPrice", product);
    }

    protected ProductPrice getUnitProductPrice(Product product) {
        this.unitProductPrice = this.getProductPrice(product, "productPrice.unitPrice", this.unitProductPrice, this.getUnitPrice(), this.getServiceRatio());
        return this.unitProductPrice;
    }

    protected BigDecimal getPrice(Product product, ProductPrice price, BigDecimal serviceRatio) {
        return this.editContext.getPrice(product, price, serviceRatio);
    }

    protected BigDecimal calculateTax(Party customer) {
        FinancialAct act = (FinancialAct)this.getObject();
        return this.editContext.getTaxRules().calculateTax(act, customer);
    }

    protected boolean updateServiceRatio(Product product) {
        BigDecimal serviceRatio;
        this.availableServiceRatio = serviceRatio = this.getServiceRatio(product);
        Property property = this.getProperty(SERVICE_RATIO);
        property.removeModifiableListener(this.serviceRatioListener);
        boolean result = property.setValue((Object)serviceRatio);
        property.addModifiableListener(this.serviceRatioListener);
        if (!TypeHelper.isA((IMObject)product, (String)"product.template")) {
            this.fixedEditor.setProduct(product, serviceRatio);
        } else {
            this.fixedEditor.setProduct(null, serviceRatio);
        }
        return result;
    }

    protected ProductPrice getProductPrice(String shortName, BigDecimal price, BigDecimal serviceRatio, Product product) {
        return this.editContext.getPricingContext().getProductPrice(shortName, price, serviceRatio, product, this.getStartTime());
    }

    protected void restrictProductSelection() {
        ProductParticipationEditor editor = this.getProductEditor(false);
        if (editor != null) {
            Party location = this.getLocation();
            boolean useLocationProducts = this.editContext.useLocationProducts();
            editor.setUseLocationProducts(useLocationProducts);
            editor.setLocation(location);
            editor.setExcludeTemplateOnlyProducts(true);
            if (useLocationProducts) {
                editor.setStockLocation(this.editContext.getStockLocation());
            }
            if (this.editContext.useMinimumQuantities() && !this.editContext.overrideMinimumQuantities()) {
                if (!MathRules.isZero((BigDecimal)this.getMinimumQuantity())) {
                    Reference product = editor.getEntityRef();
                    if (TypeHelper.isA((Reference)product, (String[])new String[]{"product.medication", "product.merchandise"})) {
                        editor.setShortNames(new String[]{product.getArchetype()});
                    } else {
                        editor.resetShortNames();
                    }
                } else {
                    editor.resetShortNames();
                }
            }
        }
    }

    protected boolean isProductReadOnly() {
        boolean result = false;
        if (this.editContext.useMinimumQuantities() && !this.editContext.overrideMinimumQuantities() && TypeHelper.isA((Reference)this.getProductRef(), (String)"product.service")) {
            BigDecimal minQuantity = this.getMinimumQuantity();
            result = !MathRules.isZero((BigDecimal)minQuantity);
        }
        return result;
    }

    protected boolean needsReadOnlyProduct() {
        return this.getProductEditor(false) != null && this.isProductReadOnly();
    }

    protected BigDecimal getAvailableServiceRatio(Product product) {
        return this.getServiceRatio(product);
    }

    protected BigDecimal getServiceRatio(Product product) {
        return this.getServiceRatio(product, null);
    }

    protected BigDecimal getServiceRatio(Product product, Entity department) {
        BigDecimal result = null;
        if (product != null && (result = this.editContext.getPricingContext().getServiceRatio(product, department, this.getStartTime())) != null && result.compareTo(BigDecimal.ONE) == 0) {
            result = null;
        }
        return result;
    }

    protected boolean showServiceRatio() {
        return this.getServiceRatio() != null || this.getAvailableServiceRatio() != null;
    }

    private ProductPrice getProductPrice(Product product, String shortName, ProductPrice current, BigDecimal price, BigDecimal serviceRatio) {
        BigDecimal defaultValue;
        ProductPrice result = null;
        if (current != null && current.getProduct().equals(product) && price.compareTo(defaultValue = this.getPrice(product, current, serviceRatio)) == 0) {
            result = current;
        }
        if (result == null) {
            result = price.compareTo(BigDecimal.ZERO) == 0 ? this.getProductPrice(shortName, product) : this.getProductPrice(shortName, price, serviceRatio, product);
        }
        return result;
    }

    protected class ServiceRatioEditor
    extends AbstractPropertyEditor {
        private final CheckBox apply;
        private final Component component;
        private final FocusGroup group;
        private final ModifiableListener listener;

        public ServiceRatioEditor(final Property property) {
            super(property);
            this.group = new FocusGroup(ServiceRatioEditor.class.getSimpleName());
            TextField field = BoundTextComponentFactory.createNumeric((Property)property, (int)StyleSheetHelper.getNumericLength());
            field.setEnabled(false);
            field.setStyleName("edit");
            this.apply = CheckBoxFactory.create((boolean)this.hasRatio());
            this.listener = modifiable -> this.onRatioChanged();
            property.addModifiableListener(this.listener);
            this.apply.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    property.removeModifiableListener(ServiceRatioEditor.this.listener);
                    if (ServiceRatioEditor.this.apply.isSelected()) {
                        property.setValue((Object)PriceActItemEditor.this.getAvailableServiceRatio());
                    } else {
                        property.setValue(null);
                    }
                    property.addModifiableListener(ServiceRatioEditor.this.listener);
                }
            });
            this.component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{field, this.apply});
        }

        public Component getComponent() {
            return this.component;
        }

        public FocusGroup getFocusGroup() {
            return this.group;
        }

        private void onRatioChanged() {
            this.apply.setSelected(this.hasRatio());
        }

        private boolean hasRatio() {
            return this.getProperty().getBigDecimal(BigDecimal.ONE).compareTo(BigDecimal.ONE) != 0;
        }
    }

    protected class PriceItemLayoutStrategy
    extends ActItemEditor.LayoutStrategy {
        public PriceItemLayoutStrategy(FixedPriceEditor editor, PropertyEditor serviceRatio) {
            super((ActItemEditor)PriceActItemEditor.this);
            this.addComponent(new ComponentState((PropertyEditor)editor));
            this.addComponent(new ComponentState(serviceRatio));
        }

        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            if (PriceActItemEditor.this.isProductReadOnly()) {
                this.addComponent(this.createComponent(this.createReadOnly(properties.get("product")), parent, context));
            }
            return super.apply(object, properties, parent, context);
        }
    }
}

