/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import nextapp.echo2.app.layout.RowLayoutData;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.contact.EmailEditor;
import org.openvpms.web.component.im.contact.EmailLauncher;
import org.openvpms.web.component.im.contact.PhoneLink;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSDialog;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AlertSummary;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.SummaryContactEditDialog;
import org.openvpms.web.workspace.summary.PartySummary;

public class CustomerSummary
extends PartySummary {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private final CustomerRules partyRules = (CustomerRules)ServiceHelper.getBean(CustomerRules.class);
    private final CustomerAccountRules accountRules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
    private final int contactLength = StyleSheetHelper.getProperty((String)"customer.summary.contact.maxlength", (int)-1);

    public CustomerSummary(Context context, HelpContext help, Preferences preferences) {
        super(context, help.topic("customer/summary"), preferences);
    }

    @Override
    protected Component createSummary(Party party, List<Alert> alerts) {
        List contacts;
        Column column = ColumnFactory.create();
        Component customerName = this.getCustomerName(party);
        column.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{customerName}));
        Component customerId = this.getCustomerId(party);
        column.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{customerId}));
        Context context = this.getContext();
        Grid grid = GridFactory.create((int)2);
        grid.setWidth(Styles.FULL_WIDTH);
        if (party.isA("party.customerperson")) {
            this.addPhone(party, grid);
            this.addEmail(party, grid);
        }
        if (this.getPreferences().getBoolean("entity.preferenceGroupSummary", "showCustomerAccount", true)) {
            Label balanceTitle = this.create("customer.account.balance");
            BigDecimal balance = this.accountRules.getBalance(party);
            Label balanceValue = this.create(balance);
            Label overdueTitle = this.create("customer.account.overdue");
            BigDecimal overdue = this.accountRules.getOverdueBalance(party, new Date());
            Label overdueValue = this.create(overdue);
            Label currentTitle = this.create("customer.account.current");
            BigDecimal current = balance.subtract(overdue);
            Label currentValue = this.create(current);
            Label unbilledTitle = this.create("customer.account.unbilled");
            BigDecimal unbilled = this.accountRules.getUnbilledAmount(party);
            Label unbilledValue = this.create(unbilled);
            Label effectiveTitle = this.create("customer.account.effective");
            BigDecimal effective = balance.add(unbilled);
            Label effectiveValue = this.create(effective);
            grid.add((Component)balanceTitle);
            grid.add((Component)balanceValue);
            grid.add((Component)overdueTitle);
            grid.add((Component)overdueValue);
            grid.add((Component)currentTitle);
            grid.add((Component)currentValue);
            grid.add((Component)unbilledTitle);
            grid.add((Component)unbilledValue);
            grid.add((Component)effectiveTitle);
            grid.add((Component)effectiveValue);
        }
        column.add((Component)grid);
        if (!alerts.isEmpty()) {
            AlertSummary alertSummary = new AlertSummary(party, alerts, context, this.getHelpContext());
            column.add((Component)ColumnFactory.create((String)"Inset.Small", (Component[])new Component[]{alertSummary.getComponent()}));
        }
        Column result = ColumnFactory.create((String)"PartySummary", (Component[])new Component[]{column});
        if (SMSHelper.isSMSEnabled((Party)context.getPractice()) && !(contacts = ContactHelper.getSMSContacts((Party)party)).isEmpty()) {
            LocalContext local = new LocalContext(context);
            local.setCustomer(party);
            Button button = ButtonFactory.create((String)"button.sms.send", () -> this.lambda$createSummary$0(contacts, (Context)local));
            result.add((Component)RowFactory.create((String)"Inset.Small", (Component[])new Component[]{button}));
        }
        return result;
    }

    protected Component getCustomerName(Party customer) {
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(customer.getObjectReference(), customer.getName(), true, this.getContext());
        viewer.setStyleName("hyperlink-bold");
        return viewer.getComponent();
    }

    protected Component getCustomerId(Party customer) {
        Label result;
        Label customerId = this.createLabel("customer.id", customer.getId());
        if (customer.isA("party.customerperson")) {
            Button communication = ButtonFactory.create(null, (String)"button.communication", () -> {
                ContextApplicationInstance instance = ContextApplicationInstance.getInstance();
                ContextHelper.setCustomer((Context)instance.getContext(), (Party)customer);
                instance.switchTo("act.customerCommunication*");
            });
            communication.setToolTipText(Messages.get((String)"customer.communication.icon"));
            Row right = RowFactory.create((Component[])new Component[]{communication});
            RowLayoutData rightLayout = new RowLayoutData();
            rightLayout.setAlignment(Alignment.ALIGN_RIGHT);
            rightLayout.setWidth(Styles.FULL_WIDTH);
            right.setLayoutData((LayoutData)rightLayout);
            result = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[]{customerId, right});
        } else {
            result = customerId;
        }
        return result;
    }

    private void refreshCustomer(Party customer) {
        GlobalContext globalContext = ContextApplicationInstance.getInstance().getContext();
        if (Objects.equals(customer, globalContext.getCustomer())) {
            globalContext.setCustomer(customer);
        }
    }

    private void addPhone(Party customer, Grid grid) {
        Row container = new Row();
        this.addPhone(customer, container);
        grid.add((Component)container);
    }

    private void addPhone(Party customer, Row container) {
        PhoneLink link = new PhoneLink((PartyRules)this.partyRules, (ArchetypeService)this.service, this.contactLength);
        Contact contact = this.partyRules.getTelephoneContact(customer);
        Component component = link.getLink(contact, true);
        if (component != null) {
            this.addContact(component, null, container);
        } else {
            Button button = ButtonFactory.create((String)"button.add", (String)"default", (boolean)false, () -> this.onCreatePhone(customer, contact, container));
            this.addContact((Component)LabelFactory.create((String)"customer.phone"), (Component)button, container);
        }
    }

    private void onCreatePhone(Party customer, Contact contact, final Row container) {
        if (contact == null) {
            contact = (Contact)this.service.create("contact.phoneNumber", Contact.class);
        }
        DefaultLayoutContext layout = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        IMObjectEditor editor = layout.getEditorFactory().create((IMObject)contact, (IMObject)customer, (LayoutContext)layout);
        final SummaryContactEditDialog dialog = new SummaryContactEditDialog(contact, editor, customer, this.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Party latest = dialog.getCustomer();
                CustomerSummary.this.addPhone(latest, container);
                CustomerSummary.this.refreshCustomer(latest);
            }
        });
        dialog.show();
    }

    private void addEmail(Party customer, Grid grid) {
        Row container = new Row();
        this.addEmail(customer, container);
        grid.add((Component)container);
    }

    private void addEmail(Party customer, Row container) {
        HelpContext help = this.getHelpContext().topic("email");
        CustomerMailContext mailContext = new CustomerMailContext(this.getContext(), true, help);
        EmailLauncher launcher = EmailLauncher.create((Party)customer, (ArchetypeService)this.service, (Context)this.getContext(), (HelpContext)help, (MailContext)mailContext);
        if (launcher != null) {
            launcher.setEmailLength(this.contactLength);
            Component mailToLink = launcher.getMailToLink();
            this.addContact((Component)launcher.getWriteButton(), mailToLink, container);
        } else {
            Button button = ButtonFactory.create((String)"button.add", (String)"default", (boolean)false, () -> this.onCreateEmail(customer, container));
            this.addContact((Component)LabelFactory.create((String)"customer.email"), (Component)button, container);
        }
    }

    private void onCreateEmail(Party customer, final Row container) {
        Contact contact = (Contact)this.service.create("contact.email", Contact.class);
        EmailEditor editor = new EmailEditor(contact, (IMObject)customer, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
        final SummaryContactEditDialog dialog = new SummaryContactEditDialog(contact, (IMObjectEditor)editor, customer, this.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Party latest = dialog.getCustomer();
                CustomerSummary.this.addEmail(latest, container);
                CustomerSummary.this.refreshCustomer(latest);
            }
        });
        dialog.show();
    }

    private void addContact(Component left, Component right, Row container) {
        container.removeAll();
        if (container.getLayoutData() == null) {
            container.setLayoutData((LayoutData)ComponentGrid.layout((int)1, (int)2));
        }
        container.add(left);
        if (right != null) {
            Row wrapper = RowFactory.create((Component[])new Component[]{right});
            wrapper.setLayoutData((LayoutData)RowFactory.rightAlign());
            container.add((Component)wrapper);
        }
    }

    private Label create(String key) {
        return LabelFactory.create((String)key);
    }

    private Label create(BigDecimal value) {
        return LabelFactory.create((Number)value, (CellLayoutData)new GridLayoutData());
    }

    private /* synthetic */ void lambda$createSummary$0(List contacts, Context local) {
        SMSDialog dialog = new SMSDialog(contacts, local, this.getHelpContext().subtopic("sms"));
        dialog.show();
    }
}

