/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import java.util.Collection;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.contact.ContactCollectionEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.relationship.SingleEntityLinkCollectionEditor;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.PatientEntityRelationshipCollectionEditor;

public class CustomerEditor
extends AbstractIMObjectEditor {
    public static final String REFERRAL = "referral";
    public static final String REFERRED_BY_CUSTOMER = "referredByCustomer";
    public static final String CONTACTS = "contacts";
    public static final String PATIENTS = "patients";
    public static final String CUSTOMER_REFERRAL = "CUSTOMER";
    private final SingleEntityLinkCollectionEditor referredByCustomerEditor;

    public CustomerEditor(Party customer, IMObject parent, LayoutContext context) {
        super((IMObject)customer, parent, context);
        CollectionProperty contacts;
        if (customer.isNew()) {
            this.initPractice(context);
        }
        if ((contacts = this.getCollectionProperty(CONTACTS)) != null) {
            ContactCollectionEditor editor = this.createContactCollectionEditor(customer, context, contacts);
            this.addEditor((Editor)editor);
            if (contacts.getMinCardinality() == 0) {
                editor.setExcludeUnmodifiedContacts(true);
            }
            this.addContact(editor, "contact.location");
            this.addContact(editor, "contact.phoneNumber");
            this.addContact(editor, "contact.email");
        }
        Property referral = this.getProperty(REFERRAL);
        CollectionProperty referredByCustomer = this.getCollectionProperty(REFERRED_BY_CUSTOMER);
        if (referral != null && referredByCustomer != null) {
            this.referredByCustomerEditor = new SingleEntityLinkCollectionEditor(referredByCustomer, (Entity)customer, context);
            this.referredByCustomerEditor.getComponent();
            this.addEditor((Editor)this.referredByCustomerEditor);
            referral.addModifiableListener(modifiable -> this.updateReferredByCustomer(referral));
        } else {
            this.referredByCustomerEditor = null;
        }
        this.getLayoutContext().getContext().setCustomer(customer);
    }

    public IMObjectEditor newInstance() {
        return new CustomerEditor((Party)this.reload((IMObject)((Party)this.getObject())), this.getParent(), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        ContactCollectionEditor contactEditor = this.getContacts();
        if (contactEditor != null) {
            strategy.addComponent(new ComponentState((PropertyEditor)contactEditor));
        }
        if (this.referredByCustomerEditor != null) {
            strategy.addComponent(new ComponentState((PropertyEditor)this.referredByCustomerEditor));
        }
        return strategy;
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateReferral(validator);
    }

    protected ContactCollectionEditor createContactCollectionEditor(Party customer, LayoutContext context, CollectionProperty contacts) {
        return new ContactCollectionEditor(contacts, (IMObject)customer, context);
    }

    protected ContactCollectionEditor getContacts() {
        Editor editor = this.getEditor(CONTACTS, false);
        return editor instanceof ContactCollectionEditor ? (ContactCollectionEditor)editor : null;
    }

    protected Contact addContact(ContactCollectionEditor editor, String shortName) {
        Contact contact = null;
        if (IMObjectHelper.getObject((String)shortName, (Collection)editor.getCurrentObjects()) == null && (contact = (Contact)IMObjectCreator.create((String)shortName)) != null) {
            ServiceHelper.getArchetypeService().deriveValues((IMObject)contact);
            editor.add((IMObject)contact);
        }
        return contact;
    }

    void setReferral(String referral) {
        this.getProperty(REFERRAL).setValue((Object)referral);
    }

    void setReferredByCustomer(Party customer) {
        EntityLinkEditor editor = this.getReferredByCustomerEditor();
        if (editor != null) {
            editor.setTarget((IMObject)customer);
        }
    }

    PatientEntityRelationshipCollectionEditor getPatientCollectionEditor() {
        return (PatientEntityRelationshipCollectionEditor)this.getEditor(PATIENTS, false);
    }

    private void initPractice(LayoutContext context) {
        IMObject object;
        String[] range;
        Party location = context.getContext().getLocation();
        CollectionProperty property = this.getCollectionProperty("practice");
        if (location != null && property != null && property.size() == 0 && (range = property.getArchetypeRange()).length == 1 && (object = IMObjectCreator.create((String)range[0])) instanceof Relationship) {
            Relationship relationship = (Relationship)object;
            relationship.setTarget(location.getObjectReference());
            property.add((Object)object);
        }
    }

    private Reference getReferredByCustomer() {
        EntityLinkEditor editor = this.getReferredByCustomerEditor();
        return editor != null ? editor.getTargetRef() : null;
    }

    private EntityLinkEditor getReferredByCustomerEditor() {
        return this.referredByCustomerEditor != null ? (EntityLinkEditor)this.referredByCustomerEditor.getCurrentEditor() : null;
    }

    private boolean validateReferral(Validator validator) {
        String referral;
        Property property = this.getProperty(REFERRAL);
        if (property != null && CUSTOMER_REFERRAL.equals(referral = property.getString())) {
            Reference referredByCustomer = this.getReferredByCustomer();
            if (referredByCustomer == null) {
                validator.add((Modifiable)property, Messages.format((String)"property.error.required", (Object[])new Object[]{this.referredByCustomerEditor.getProperty().getDisplayName()}));
            } else if (this.getObject().getObjectReference().equals((Object)referredByCustomer)) {
                validator.add((Modifiable)property, Messages.format((String)"customer.sameReferralCustomer", (Object[])new Object[0]));
            }
        }
        return validator.isValid();
    }

    private void updateReferredByCustomer(Property referred) {
        IMObjectEditor editor;
        if (!CUSTOMER_REFERRAL.equals(referred.getString()) && (editor = this.referredByCustomerEditor.getCurrentEditor()) != null) {
            ((EntityLinkEditor)editor).setTarget(null);
        }
    }
}

