/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.alert;

import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.act.AbstractActTableModel;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.alert.AlertPriorityTransformer;

public class AlertTableModel
extends AbstractActTableModel<Act> {
    private int priorityIndex;
    private int alertIndex;
    private Map<String, String> priorities;
    private Alert alert;

    public AlertTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        if (column == this.priorityIndex) {
            return new SortConstraint[]{new VirtualNodeSortConstraint("alertType.priority", ascending, AlertPriorityTransformer.INSTANCE)};
        }
        if (column == this.alertIndex) {
            return new SortConstraint[]{new VirtualNodeSortConstraint("alertType", ascending)};
        }
        return super.getSortConstraints(column, ascending);
    }

    protected Object getValue(Act object, TableColumn column, int row) {
        Alert alert = this.getAlert(object);
        int index = column.getModelIndex();
        if (index == this.priorityIndex) {
            return this.getPriority(alert);
        }
        if (index == this.alertIndex) {
            return this.getAlertName(alert);
        }
        return super.getValue((IMObject)object, column, row);
    }

    private Alert getAlert(Act object) {
        if (this.alert == null || this.alert.getAlert() != object) {
            this.alert = Alert.create((Act)object);
        }
        return this.alert;
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        this.priorityIndex = this.getNextModelIndex((TableColumnModel)model);
        this.alertIndex = this.priorityIndex + 1;
        TableColumn priority = AlertTableModel.createTableColumn((int)this.priorityIndex, (String)"alert.priority");
        TableColumn alert = AlertTableModel.createTableColumn((int)this.alertIndex, (String)"alert.name");
        model.addColumn(priority);
        model.moveColumn(model.getColumnCount() - 1, 0);
        model.addColumn(alert);
        model.moveColumn(model.getColumnCount() - 1, 1);
        return model;
    }

    protected String[] getNodeNames() {
        return new String[]{"startTime", "endTime", "status", "reason"};
    }

    private Label getPriority(Alert alert) {
        String code;
        Label result = LabelFactory.create();
        if (alert != null && (code = alert.getPriorityCode()) != null) {
            result.setText(this.getPriorityName(code));
        }
        return result;
    }

    private Label getAlertName(Alert alert) {
        Label result = LabelFactory.create();
        if (alert != null) {
            result.setText(alert.getName());
            Color colour = alert.getColour();
            if (colour != null) {
                TableLayoutData layout = new TableLayoutData();
                result.setLayoutData((LayoutData)layout);
                layout.setBackground(colour);
                result.setForeground(alert.getTextColour());
            }
        }
        return result;
    }

    private String getPriorityName(String code) {
        String name;
        if (this.priorities == null) {
            this.priorities = LookupNameHelper.getLookupNames((String)"lookup.customerAlertType", (String)"priority");
        }
        if ((name = this.priorities.get(code)) == null) {
            name = code;
        }
        return name;
    }
}

