/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.alert;

import org.apache.commons.collections.Transformer;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.system.ServiceHelper;

public class AlertPriorityTransformer
implements Transformer {
    public static final Transformer INSTANCE = new AlertPriorityTransformer();

    public Object transform(Object input) {
        Alert.Rank result = null;
        Act act = (Act)input;
        if (act.isA("act.customerAlert")) {
            Lookup alertType = ServiceHelper.getLookupService().getLookup((IMObject)act, "alertType");
            result = this.getRank((IMObject)alertType);
        } else if (act.isA("act.patientAlert")) {
            IMObject alertType = ServiceHelper.getArchetypeService().getBean((IMObject)act).getTarget("alertType");
            result = this.getRank(alertType);
        }
        return result;
    }

    private Alert.Rank getRank(IMObject object) {
        Alert.Rank result = null;
        if (object != null) {
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean(object);
            String priority = bean.getString("priority");
            result = priority != null ? Alert.Rank.valueOf((String)priority) : null;
        }
        return result;
    }
}

