/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.user;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.prefs.PreferenceService;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.ReferenceDataService;
import org.openvpms.smartflow.client.SyncState;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.prefs.PreferencesDialog;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class UserCRUDWindow
extends ResultSetCRUDWindow<User> {
    private final FlowSheetServiceFactory flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
    private static final String EDIT_PREFERENCES_ID = "button.editPreferences";
    private static final String DEFAULT_PREFERENCES_ID = "button.defaultPreferences";
    private static final String RESET_PREFERENCES_ID = "button.resetPreferences";
    private static final String PASSWORD_POLICY_ID = "button.passwordPolicy";
    private static final String SYNCH_ID = "button.synchwithsfs";

    public UserCRUDWindow(Archetypes<User> archetypes, Query<User> query, ResultSet<User> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(DEFAULT_PREFERENCES_ID, this::onDefaultPreferences);
        buttons.add(EDIT_PREFERENCES_ID, this::onEditPreferences);
        buttons.add(RESET_PREFERENCES_ID, this::onResetPreferences);
        buttons.add(PASSWORD_POLICY_ID, this::onPasswordPolicy);
        Party location = this.getContext().getLocation();
        if (location != null && this.flowSheetServiceFactory.isSmartFlowSheetEnabled(location)) {
            buttons.add(SYNCH_ID, this::onSynchronise);
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(DEFAULT_PREFERENCES_ID, this.getContext().getPractice() != null);
        buttons.setEnabled(EDIT_PREFERENCES_ID, enable);
        buttons.setEnabled(RESET_PREFERENCES_ID, enable);
    }

    private void onDefaultPreferences() {
        PreferencesDialog dialog = new PreferencesDialog(this.getContext().getPractice(), null, this.getContext());
        dialog.setTitle(Messages.get((String)"admin.user.prefs.default.title"));
        dialog.show();
    }

    private void onEditPreferences() {
        User user = (User)IMObjectHelper.reload((IMObject)this.getObject());
        if (user != null) {
            Context context = this.getContext();
            PreferencesDialog dialog = new PreferencesDialog((Party)user, context.getPractice(), true, (Context)new LocalContext(context));
            dialog.setTitle(Messages.format((String)"admin.user.prefs.edit.title", (Object[])new Object[]{user.getName()}));
            dialog.show();
        } else {
            this.onRefresh(this.getObject());
        }
    }

    private void onResetPreferences() {
        final User user = (User)this.getObject();
        if (user != null) {
            String title = Messages.get((String)"admin.user.resetprefs.title");
            String message = Messages.format((String)"admin.user.resetprefs.message", (Object[])new Object[]{user.getName()});
            ConfirmationDialog.show((String)title, (String)message, (String[])PopupDialog.YES_NO, (WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    PreferenceService service = (PreferenceService)ServiceHelper.getBean(PreferenceService.class);
                    service.reset((Party)user, UserCRUDWindow.this.getContext().getPractice());
                }
            });
        }
    }

    private void onPasswordPolicy() {
        SingletonService service = (SingletonService)ServiceHelper.getBean(SingletonService.class);
        Entity policy = (Entity)service.get("entity.globalSettingsPassword", Entity.class, true);
        HelpContext edit = this.createEditTopic((IMObject)policy);
        LayoutContext context = this.createLayoutContext(edit);
        IMObjectEditor editor = context.getEditorFactory().create((IMObject)policy, context);
        editor.getComponent();
        EditDialog dialog = this.createEditDialog(editor);
        dialog.show();
    }

    private void onSynchronise() {
        HelpContext help = this.getHelpContext().subtopic("sync");
        ConfirmationDialog.show((String)Messages.get((String)"admin.user.sync.title"), (String)Messages.get((String)"admin.user.sync.message"), (String[])ConfirmationDialog.YES_NO, (HelpContext)help, (WindowPaneListener)new PopupDialogListener(){

            public void onYes() {
                UserCRUDWindow.this.synchroniseClinicians();
            }
        });
    }

    private void synchroniseClinicians() {
        ReferenceDataService service = this.flowSheetServiceFactory.getReferenceDataService(this.getContext().getLocation());
        SyncState sync = service.synchroniseMedics();
        String title = Messages.get((String)"admin.user.sync.title");
        String message = sync.changed() ? Messages.get((String)"admin.user.sync.updated") : Messages.get((String)"admin.user.sync.noupdate");
        InformationDialog.show((String)title, (String)message);
    }
}

