/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.type;

import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.service.archetype.helper.IMObjectGraph;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityLinkCollectionTargetEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ReminderTypeEditor
extends AbstractIMObjectEditor {
    private static final String COUNTS = "counts";

    public ReminderTypeEditor(Entity object, IMObject parent, LayoutContext context) {
        super((IMObject)object, parent, context);
        this.init(object, this.getLayoutContext());
    }

    public ReminderTypeEditor(IMObjectGraph graph, LayoutContext context) {
        super(graph, context);
        this.init((Entity)this.getObject(), this.getLayoutContext());
    }

    public IMObjectEditor newInstance() {
        return new ReminderTypeEditor((Entity)this.reload(this.getObject()), this.getParent(), this.newLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        CountsEditor counts = (CountsEditor)this.getEditor(COUNTS, false);
        strategy.addComponent(new ComponentState((PropertyEditor)counts));
        return strategy;
    }

    private void init(Entity object, LayoutContext context) {
        this.addEditor((Editor)new CountsEditor(this.getCollectionProperty(COUNTS), object, context));
    }

    private static class CountsEditor
    extends EntityLinkCollectionTargetEditor {
        public CountsEditor(CollectionProperty property, Entity entity, LayoutContext context) {
            super(property, entity, context);
        }

        public IMObject create(String archetype) {
            IMObject object = super.create(archetype);
            if (object != null) {
                int maxCount = 0;
                for (IMObject reminderCount : this.getCurrentObjects()) {
                    IMObjectBean bean = this.getBean(reminderCount);
                    int count = bean.getInt("count");
                    if (count < maxCount) continue;
                    maxCount = count + 1;
                }
                IMObjectBean bean = this.getBean(object);
                bean.setValue("count", (Object)maxCount);
            }
            return object;
        }

        public boolean add(IMObject object) {
            boolean result = super.add(object);
            this.resequence();
            return result;
        }

        public void remove(IMObject object) {
            super.remove(object);
            this.resequence();
        }

        protected void swapped(IMObject object1, IMObject object2) {
            this.resequence();
        }

        protected boolean doValidation(Validator validator) {
            return super.doValidation(validator) && this.validateOverdueIntervals(validator);
        }

        private boolean validateOverdueIntervals(Validator validator) {
            boolean valid = true;
            DateTime from = new DateTime();
            TreeMap<Integer, DateTime> overdue = new TreeMap<Integer, DateTime>();
            for (IMObject object : this.getCurrentObjects()) {
                IMObjectBean bean = this.getBean(object);
                int count = bean.getInt("count");
                int interval = bean.getInt("interval");
                String units = bean.getString("units");
                if (units == null) continue;
                Period period = DateUnits.fromString((String)units).toPeriod(interval);
                overdue.put(count, from.withPeriodAdded((ReadablePeriod)period, 1));
            }
            Map.Entry last = null;
            for (Map.Entry entry : overdue.entrySet()) {
                if (last == null || ((DateTime)entry.getValue()).compareTo((ReadableInstant)last.getValue()) > 0) {
                    last = entry;
                    continue;
                }
                int count1 = (Integer)last.getKey();
                int count2 = (Integer)entry.getKey();
                String message = Messages.format((String)"reminder.type.overdueintervals", (Object[])new Object[]{count1, count2});
                validator.add((Modifiable)this, new ValidatorError(message));
                valid = false;
                break;
            }
            return valid;
        }

        private void resequence() {
            int count = 0;
            for (IMObject reminderCount : this.getCurrentObjects()) {
                IMObjectEditor editor = this.getEditor(reminderCount);
                editor.getProperty("count").setValue((Object)count++);
            }
        }
    }
}

