/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template.paymentprocessor;

import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.macro.MacroVariables;

public class PaymentProcessorSMSEvaluator {
    private final Party practice;
    private final SMSTemplateEvaluator evaluator;
    private final ArchetypeService service;
    private final LookupService lookups;

    public PaymentProcessorSMSEvaluator(Party practice, SMSTemplateEvaluator evaluator, ArchetypeService service, LookupService lookups) {
        this.practice = practice;
        this.evaluator = evaluator;
        this.service = service;
        this.lookups = lookups;
    }

    public String evaluate(Entity template, FinancialAct transaction) {
        IMObjectBean bean = this.service.getBean((IMObject)transaction);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party location = (Party)bean.getTarget("location", Party.class);
        Entity processor = (Entity)bean.getTarget("paymentProcessor", Entity.class);
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        context.setLocation(location);
        context.setPractice(this.practice);
        MacroVariables variables = new MacroVariables((Context)context, this.service, this.lookups);
        variables.add("txn", (Object)transaction);
        variables.add("url", (Object)bean.getString("url"));
        variables.add("processor", (Object)(processor != null ? processor.getName() : null));
        variables.add("amount", (Object)transaction.getTotal());
        variables.add("description", (Object)transaction.getDescription());
        String result = this.evaluator.evaluate(template, (Object)transaction, variables);
        return result;
    }
}

