/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template.account;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Component;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.customer.CustomerReferenceEditor;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.SMSTemplateSampler;
import org.openvpms.web.workspace.customer.account.AccountReminderEvaluator;

public class SMSAccountReminderTemplateSampler
extends SMSTemplateSampler {
    private final AccountReminderEvaluator evaluator;
    private final SimpleProperty customer;
    private final SimpleProperty location;
    private final SimpleProperty balance;
    private static final String LOCATION = "location";
    private static final String CUSTOMER = "customer";

    public SMSAccountReminderTemplateSampler(Entity template, LayoutContext layoutContext) {
        super(template, layoutContext);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        Context context = layoutContext.getContext();
        this.evaluator = new AccountReminderEvaluator(context.getPractice(), (SMSTemplateEvaluator)ServiceHelper.getBean(SMSTemplateEvaluator.class), (ArchetypeService)service, ServiceHelper.getLookupService());
        ModifiableListener listener = modifiable -> this.evaluate();
        this.customer = new SimpleProperty(CUSTOMER, null, IMObjectReference.class, DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (String)CUSTOMER, (ArchetypeService)service));
        this.customer.setArchetypeRange(new String[]{"party.customerperson"});
        if (context.getCustomer() != null) {
            this.customer.setValue((Object)context.getCustomer().getObjectReference());
        }
        this.location = new SimpleProperty(LOCATION, null, IMObjectReference.class, DescriptorHelper.getDisplayName((String)"act.customerAccountChargesInvoice", (String)LOCATION, (ArchetypeService)service));
        this.location.setArchetypeRange(new String[]{"party.organisationLocation"});
        if (context.getLocation() != null) {
            this.location.setValue((Object)context.getLocation().getObjectReference());
        }
        this.balance = new SimpleProperty("balance", (Object)new BigDecimal("100.25"), BigDecimal.class, Messages.get((String)"admin.template.smsaccountreminder.balance"));
        this.customer.addModifiableListener(listener);
        this.location.addModifiableListener(listener);
        this.balance.addModifiableListener(listener);
    }

    @Override
    protected void layoutFields(ComponentGrid grid, FocusGroup group, LayoutContext context) {
        CustomerReferenceEditor customerSelector = new CustomerReferenceEditor((Property)this.customer, null, context);
        DefaultIMObjectReferenceEditor locationSelector = new DefaultIMObjectReferenceEditor((Property)this.location, null, context);
        grid.add(new Component[]{LabelFactory.text((String)this.customer.getDisplayName()), customerSelector.getComponent(), LabelFactory.text((String)this.location.getDisplayName()), locationSelector.getComponent()});
        Component amount = context.getComponentFactory().create((Property)this.balance);
        grid.add(new Component[]{LabelFactory.text((String)this.balance.getDisplayName()), amount});
        group.add(customerSelector.getFocusGroup());
        group.add(locationSelector.getFocusGroup());
        group.add(amount);
    }

    @Override
    protected String evaluate(Entity template, Context context) {
        FinancialAct act = (FinancialAct)IMObjectCreator.create((String)"act.customerAccountChargesInvoice");
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        bean.setTarget(CUSTOMER, this.customer.getReference());
        bean.setTarget(LOCATION, this.location.getReference());
        act.setStatus("POSTED");
        act.setActivityStartTime(new Date());
        act.setActivityEndTime(new Date());
        act.setTotal(this.balance.getBigDecimal(BigDecimal.ZERO));
        act.setAllocatedAmount(BigDecimal.ZERO);
        return this.evaluator.evaluate(template, act, (Party)IMObjectHelper.getObject((Reference)this.customer.getReference(), Party.class), (Party)IMObjectHelper.getObject((Reference)this.location.getReference(), Party.class));
    }
}

