/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.sms.internal.service.SMSLengthCalculator;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultEditableComponentFactory;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.BoundSMSTextArea;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class SMSTemplateSampler {
    private final Entity template;
    private final int maxParts;
    private final LayoutContext layoutContext;
    private final SimpleProperty message = new SimpleProperty("message", null, String.class, Messages.get((String)"sms.message"));
    private final Label status;
    private final FocusGroup group = new FocusGroup("Sampler");

    public SMSTemplateSampler(Entity template, LayoutContext layoutContext) {
        this.template = template;
        LocalContext local = new LocalContext(layoutContext.getContext());
        this.layoutContext = new DefaultLayoutContext(true, (Context)local, layoutContext.getHelpContext());
        this.layoutContext.setComponentFactory((IMObjectComponentFactory)new DefaultEditableComponentFactory(this.layoutContext));
        this.status = LabelFactory.create((boolean)true, (boolean)true);
        SMSService smsService = ServiceHelper.getSMSService();
        this.maxParts = smsService.getMaxParts();
        this.message.setMaxLength(-1);
    }

    public void evaluate() {
        String value;
        String statusText = null;
        try {
            value = this.evaluate(this.template, this.layoutContext.getContext());
            if (value != null) {
                int maxLength = SMSLengthCalculator.getMaxLength((int)this.maxParts, (String)value);
                if (value.length() > maxLength) {
                    value = value.substring(0, maxLength);
                    statusText = Messages.get((String)"sms.truncated");
                }
            }
        }
        catch (Throwable exception) {
            value = null;
            statusText = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
        }
        this.message.setValue((Object)value);
        this.status.setText(statusText);
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    public Component getComponent() {
        FocusGroup group = this.getFocusGroup();
        BoundSMSTextArea message = new BoundSMSTextArea((Property)this.message, 40, 15);
        message.setMaxParts(this.maxParts);
        message.setStyleName("default");
        message.setEnabled(false);
        Label messageLabel = LabelFactory.create();
        messageLabel.setText(this.message.getDisplayName());
        ComponentGrid grid = new ComponentGrid();
        this.layoutFields(grid, group, this.layoutContext);
        grid.add(new Component[]{LabelFactory.create((String)"sms.title", (String)"bold"), LabelFactory.create(), LabelFactory.create((String)"sms.appointment.status", (String)"bold")});
        this.status.setTextAlignment(Alignment.ALIGN_TOP);
        this.status.setLayoutData((LayoutData)ComponentGrid.layout((Alignment)new Alignment(3, 6)));
        grid.add(new Component[]{LabelFactory.create((String)"sms.message"), RowFactory.create((Component[])new Component[]{message})});
        grid.set(grid.getRows() - 1, 2, 2, (Component)this.status);
        group.add((Component)message);
        return ColumnFactory.create((String)"Inset", (Component[])new Component[]{grid.createGrid()});
    }

    protected abstract void layoutFields(ComponentGrid var1, FocusGroup var2, LayoutContext var3);

    protected abstract String evaluate(Entity var1, Context var2);

    protected LayoutContext getContext() {
        return this.layoutContext;
    }
}

