/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.smartflow;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetException;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.event.EventStatus;
import org.openvpms.smartflow.event.SmartFlowSheetEventService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.resource.i18n.Messages;

class Status {
    private final Party location;
    private final SmartFlowSheetEventService service;
    private final FlowSheetServiceFactory factory;
    private final PracticeService practiceService;
    private final String key;
    private String status;
    private ComponentStatus apiStatus = ComponentStatus.NOT_CONFIGURED;
    private String apiError;
    private ComponentStatus queueStatus = ComponentStatus.NOT_CONFIGURED;
    private String queueError;
    private EventStatus eventStatus;

    public Status(Party location, SmartFlowSheetEventService service, FlowSheetServiceFactory factory, PracticeService practiceService) {
        this.location = location;
        this.factory = factory;
        this.service = service;
        this.practiceService = practiceService;
        this.key = this.getAPIKey(location, factory);
        this.refresh();
    }

    public long getId() {
        return this.location.getId();
    }

    public String getName() {
        return this.location.getName();
    }

    public String getDisplayKey() {
        String result = null;
        if (this.key != null) {
            result = this.key.length() >= 10 ? StringUtils.abbreviate((String)this.key, (int)10) : this.key;
        }
        return result;
    }

    public String getStatus() {
        return this.status;
    }

    public ComponentStatus getAPIStatus() {
        return this.apiStatus;
    }

    public String getAPIError() {
        return this.apiError;
    }

    public ComponentStatus getQueueStatus() {
        return this.queueStatus;
    }

    public String getQueueError() {
        return this.queueError != null ? this.queueError : this.eventStatus.getErrorMessage();
    }

    public Date getEventReceived() {
        return this.eventStatus != null ? this.eventStatus.getReceived() : null;
    }

    public void refresh() {
        this.apiStatus = ComponentStatus.NOT_CONFIGURED;
        this.queueStatus = ComponentStatus.NOT_CONFIGURED;
        this.status = null;
        this.apiError = null;
        this.queueError = null;
        this.eventStatus = null;
        if (this.key != null) {
            try {
                this.factory.getReferenceDataService(this.location).getDepartments();
                this.apiStatus = ComponentStatus.CONNECTED;
            }
            catch (Throwable exception) {
                this.apiStatus = ComponentStatus.ERROR;
                this.apiError = this.getError(exception);
            }
            try {
                this.factory.getReferenceDataService(this.location).getServiceBusConfig();
                this.eventStatus = this.service.getStatus(this.location);
                if (this.eventStatus.getError() == null) {
                    if (this.practiceService.getServiceUser() == null) {
                        this.queueStatus = ComponentStatus.ERROR;
                        this.queueError = Messages.get((String)"admin.system.smartflow.noserviceuser");
                    } else {
                        this.queueStatus = ComponentStatus.CONNECTED;
                    }
                } else {
                    this.queueStatus = ComponentStatus.ERROR;
                    this.queueError = this.eventStatus.getErrorMessage();
                }
            }
            catch (Throwable exception) {
                this.queueStatus = ComponentStatus.ERROR;
                this.queueError = this.getError(exception);
            }
        }
        this.status = this.apiStatus == ComponentStatus.ERROR || this.queueStatus == ComponentStatus.ERROR ? Messages.get((String)"admin.system.smartflow.error") : (this.apiStatus == ComponentStatus.NOT_CONFIGURED || this.queueStatus == ComponentStatus.NOT_CONFIGURED ? Messages.get((String)"admin.system.smartflow.notconfigured") : Messages.get((String)"admin.system.smartflow.connected"));
    }

    public String getAPIStatusName() {
        return this.getStatusName(this.apiStatus);
    }

    public String getQueueStatusName() {
        return this.getStatusName(this.queueStatus);
    }

    private String getAPIKey(Party location, FlowSheetServiceFactory factory) {
        String result;
        try {
            String key = factory.getClinicAPIKey(location);
            result = key != null ? StringUtils.abbreviate((String)key, (int)10) : null;
        }
        catch (Throwable exception) {
            result = exception.getMessage();
        }
        return result;
    }

    private String getStatusName(ComponentStatus status) {
        String result;
        switch (status) {
            case NOT_CONFIGURED: {
                result = Messages.get((String)"admin.system.smartflow.notconfigured");
                break;
            }
            case CONNECTED: {
                result = Messages.get((String)"admin.system.smartflow.connected");
                break;
            }
            default: {
                result = Messages.get((String)"admin.system.smartflow.error");
            }
        }
        return result;
    }

    private String getError(Throwable exception) {
        String result = exception instanceof FlowSheetException ? exception.getMessage() : ErrorFormatter.format((Throwable)exception);
        return result;
    }

    public static enum ComponentStatus {
        NOT_CONFIGURED,
        CONNECTED,
        ERROR;

    }
}

