/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.settings;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.settings.SettingsCache;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.singleton.SingletonService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

class SettingsTab
implements TabComponent {
    private final String archetype;
    private final HelpContext help;
    private final Column container = ColumnFactory.create();
    private final String title;
    private final String[] buttons;

    public SettingsTab(String archetype, HelpContext help, String ... buttons) {
        this.archetype = archetype;
        this.help = help.topic(archetype + "/edit");
        this.buttons = buttons;
        this.title = DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    public String getTitle() {
        return this.title;
    }

    public HelpContext getHelpContext() {
        return this.help;
    }

    public void show() {
        SettingsCache cache = (SettingsCache)ServiceHelper.getBean(SettingsCache.class);
        IMObjectBean group = cache.getGroup(this.archetype, true);
        IMObject settings = group.getObject();
        HelpContext view = this.help.topic(settings, "view");
        DefaultLayoutContext context = new DefaultLayoutContext(true, (Context)new LocalContext(), view);
        IMObjectViewer viewer = new IMObjectViewer(settings, (LayoutContext)context);
        this.container.removeAll();
        this.container.add(viewer.getComponent());
    }

    public Component getComponent() {
        return this.container;
    }

    public void edit() {
        SingletonService service = (SingletonService)ServiceHelper.getBean(SingletonService.class);
        final Entity settings = (Entity)service.get(this.archetype, Entity.class, true);
        final long version = settings.getVersion();
        HelpContext edit = this.help.topic((IMObject)settings, "edit");
        DefaultLayoutContext context = new DefaultLayoutContext(true, (Context)new LocalContext(), edit);
        IMObjectEditor editor = context.getEditorFactory().create((IMObject)settings, (LayoutContext)context);
        editor.getComponent();
        EditDialog dialog = ((EditDialogFactory)ServiceHelper.getBean(EditDialogFactory.class)).create(editor, context.getContext());
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                if (version != settings.getVersion()) {
                    SettingsTab.this.onChanged(settings);
                }
            }
        });
        dialog.show();
    }

    public String[] getButtons() {
        return this.buttons;
    }

    public void onButton(String button) {
    }

    protected void onChanged(Entity settings) {
        this.show();
    }
}

