/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.settings;

import echopointng.TabbedPane;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.SplitPane;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.factory.TabbedPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.system.settings.OpenOfficeSettings;
import org.openvpms.web.workspace.admin.system.settings.SettingsTab;

public class SettingsDialog
extends ModalDialog {
    private final ObjectTabPaneModel<SettingsTab> model;
    private final TabbedPane pane;
    private final SplitPane container;
    private int currentIndex;
    private SettingsTab currentTab;
    private static final String EDIT_ID = "button.edit";

    public SettingsDialog(HelpContext help) {
        super(Messages.get((String)"admin.system.settings"), new String[]{EDIT_ID, "close"}, help);
        Column tabContainer = ColumnFactory.create((String)"InsetY");
        this.container = SplitPaneFactory.create((int)5, (String)"TabbedBrowser", (Component[])new Component[0]);
        this.container.add((Component)tabContainer);
        this.model = new ObjectTabPaneModel((Component)tabContainer);
        this.addTab("entity.globalSettingsFirewall");
        if (OpenOfficeSettings.isAvailable()) {
            this.addTab(new OpenOfficeSettings(help));
        }
        this.addTab("entity.globalSettingsPassword");
        this.addTab("entity.globalSettingsQuery");
        this.addTab("entity.globalSettingsReport");
        this.pane = TabbedPaneFactory.create(this.model);
        this.currentIndex = -1;
        this.pane.addPropertyChangeListener(evt -> this.onTabSelected());
        tabContainer.add((Component)this.pane);
        this.getLayout().add((Component)this.container);
        this.pane.setSelectedIndex(0);
        this.resize("SettingsDialog.size");
    }

    public HelpContext getHelpContext() {
        HelpContext help = this.currentTab != null ? this.currentTab.getHelpContext() : null;
        return help != null ? help : super.getHelpContext();
    }

    protected void onButton(String button) {
        if (EDIT_ID.equals(button)) {
            this.onEdit();
        } else if (!"close".equals(button)) {
            this.onSettingsButton(button);
        } else {
            super.onButton(button);
        }
    }

    private void onSettingsButton(String button) {
        if (this.currentTab != null) {
            this.currentTab.onButton(button);
        }
    }

    private void onTabSelected() {
        int index = this.pane.getSelectedIndex();
        if (index != this.currentIndex) {
            SettingsTab tab;
            this.currentIndex = index;
            if (this.container.getComponentCount() == 2) {
                this.container.remove(1);
            }
            if (this.currentTab != null) {
                ButtonSet buttons = this.getButtons();
                for (String button : this.currentTab.getButtons()) {
                    buttons.remove(button);
                }
            }
            if ((tab = (SettingsTab)this.model.getObject(index)) != null) {
                if (tab.getButtons().length > 0) {
                    ButtonSet buttons = this.getButtons();
                    buttons.remove("close");
                    for (String button : tab.getButtons()) {
                        this.addButton(button);
                    }
                    this.addButton("close");
                }
                try {
                    this.container.add(tab.getComponent());
                    tab.show();
                    this.currentTab = tab;
                }
                catch (Throwable exception) {
                    this.currentTab = null;
                    ErrorHelper.show((Throwable)exception);
                }
            }
        }
    }

    private void onEdit() {
        SettingsTab tab = (SettingsTab)this.model.getObject(this.currentIndex);
        if (tab != null) {
            tab.edit();
        }
    }

    private void addTab(String archetype) {
        SettingsTab tab = new SettingsTab(archetype, this.getHelpContext(), new String[0]);
        this.addTab(tab);
    }

    private void addTab(SettingsTab tab) {
        this.model.addTab((Object)tab, tab.getTitle(), (Component)new Label());
    }
}

