/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.firewall;

import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.workspace.admin.system.firewall.FirewallEntryEditor;

public class FirewallLayoutStrategy
extends AbstractLayoutStrategy {
    public static final String FIRST_ALLOWED = "allowed0";

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ArchetypeNodes nodes = new ArchetypeNodes();
        for (Property property : properties.getProperties()) {
            if (!property.getName().startsWith("allowed") || property.getName().equals(FIRST_ALLOWED)) continue;
            nodes.exclude(new String[]{property.getName()});
        }
        nodes.complex(new String[]{FIRST_ALLOWED});
        this.setArchetypeNodes(nodes);
        if (this.getComponent(FIRST_ALLOWED) == null) {
            FirewallSettings settings = new FirewallSettings((Entity)object, (ArchetypeService)this.getService());
            PagedIMTable table = new PagedIMTable((IMTableModel)new AddressTableModel());
            table.setResultSet((ResultSet)new ListResultSet(settings.getAllowedAddresses(), 10));
            this.addComponent(new ComponentState(table.getComponent(), properties.get(FIRST_ALLOWED)));
        }
        return super.apply(object, properties, parent, context);
    }

    private static class AddressTableModel
    extends AbstractIMTableModel<FirewallEntry> {
        private static final int ADDRESS_INDEX = 0;
        private static final int ACTIVE_INDEX = 1;
        private static final int DESCRIPTION_INDEX = 2;
        private static final int RANGE_INDEX = 3;

        public AddressTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(AddressTableModel.createTableColumn((int)0, (String)"admin.system.firewall.address"));
            model.addColumn(AddressTableModel.createTableColumn((int)1, (String)"table.imobject.active"));
            model.addColumn(AddressTableModel.createTableColumn((int)2, (String)"table.imobject.description"));
            model.addColumn(AddressTableModel.createTableColumn((int)3, (String)"admin.system.firewall.range"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return new SortConstraint[0];
        }

        protected Object getValue(FirewallEntry object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getAddress();
                    break;
                }
                case 1: {
                    result = this.getCheckBox(object.isActive());
                    break;
                }
                case 2: {
                    result = object.getDescription();
                    break;
                }
                case 3: {
                    result = FirewallEntryEditor.getRange(object.getAddress());
                }
            }
            return result;
        }
    }
}

