/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.firewall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.business.dao.im.security.IUserDAO;
import org.openvpms.component.business.domain.im.security.User;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

class AddressCoverageValidator {
    private final SessionMonitor sessionMonitor;
    private final IUserDAO users;
    private final ArchetypeService service;
    private final Map<String, Boolean> connectFromAnywhere = new HashMap<String, Boolean>();

    public AddressCoverageValidator(SessionMonitor sessionMonitor, IUserDAO users, ArchetypeService service) {
        this.sessionMonitor = sessionMonitor;
        this.users = users;
        this.service = service;
    }

    public Excluded getFirstExcludedAddress(List<String> addresses, FirewallSettings.AccessType accessType) {
        Excluded result = null;
        boolean connectFromAnywhere = accessType == FirewallSettings.AccessType.ALLOWED_USER;
        List<IpAddressMatcher> matchers = this.getMatchers(addresses);
        for (SessionMonitor.Session session : this.sessionMonitor.getSessions()) {
            String host = session.getHost();
            if (host == null || connectFromAnywhere && this.userCanConnectFromAnywhere(session.getName())) continue;
            boolean found = false;
            for (IpAddressMatcher matcher : matchers) {
                if (!matcher.matches(host)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = new Excluded(host, session.getName());
            break;
        }
        return result;
    }

    private boolean userCanConnectFromAnywhere(String name) {
        return this.connectFromAnywhere.computeIfAbsent(name, username -> {
            boolean result = false;
            User user = this.users.getUser(username);
            if (user != null) {
                IMObjectBean bean = this.service.getBean((IMObject)user);
                result = bean.getBoolean("connectFromAnywhere");
            }
            return result;
        });
    }

    private List<IpAddressMatcher> getMatchers(List<String> addresses) {
        ArrayList<IpAddressMatcher> result = new ArrayList<IpAddressMatcher>();
        for (String address : addresses) {
            result.add(new IpAddressMatcher(address));
        }
        return result;
    }

    public static class Excluded {
        private final String address;
        private final String user;

        public Excluded(String address, String user) {
            this.address = address;
            this.user = user;
        }

        public String getAddress() {
            return this.address;
        }

        public String getUser() {
            return this.user;
        }
    }
}

